<?php

register_nav_menus( array(
	'main_menu' => 'Main Menu',
) );
add_theme_support( 'post-thumbnails' );
add_image_size( 'homepage-thumb', 200, 200, true );
add_image_size( 'car-rental-thumb', 285, 148, true );
add_image_size( 'testimonial-photo', 440, 299, true );

function carrent_theme_default_script() {
	if (!is_admin()) {
		wp_deregister_script('jquery');
		wp_register_script('jquery', '//ajax.googleapis.com/ajax/libs/jquery/2.0.3/jquery.min.js', false, '1.9.1');
		wp_enqueue_script('jquery');
		wp_register_script('modernizr', 'http://cdnjs.cloudflare.com/ajax/libs/modernizr/2.5.3/modernizr.min.js', false, '2.5.3');
		wp_enqueue_script('modernizr');
	}
}
add_action('init', 'carrent_theme_default_script');

function theme_name_scripts() {
       wp_enqueue_style( 'style-main', get_stylesheet_uri() );
}

add_action( 'wp_enqueue_scripts', 'theme_name_scripts' );

function carrent_limit_words($words, $limit, $append = ' &hellip;') {
       // Add 1 to the specified limit becuase arrays start at 0
       $limit = $limit+1;
       // Store each individual word as an array element
       // Up to the limit
       $words = explode(' ', $words, $limit);
       // Shorten the array by 1 because that final element will be the sum of all the words after the limit
       array_pop($words);
       // Implode the array for output, and append an ellipse
       $words = implode(' ', $words) . $append;
       // Return the result
       return $words;
}