<?php 
/*
Template Name:  Pressure Tanks - Galvanize
 * @name		Pressure Tanks - Galvanize
 * @type		PHP page
 * @desc		Pressure Tanks - Galvanize

*/
get_header();
if ( function_exists( 'ot_get_option' ) ) {
  $ptgdefault = ot_get_option( 'ptgdefault' );
  $ptgwimg = ot_get_option( 'ptgwimg' );
}
?>
<content class="products">
    <div id="galvanize">
    	<div class="wrapper">
        	<div class="post-entry">
                <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
                    <?php 
if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
	the_post_thumbnail('large');
} 
?><h2><?php the_title(); ?></h2>
                    <?php the_content(); ?>
                <?php endwhile; ?>
            </div>
        </div>
    </div>
    <div id="galvanize-product">
            <div class="wrapper">
				<?php //include("converter.php");?>
                        <div class="ps-content">
            			<div id="product-tabs">
                    	<div class="items">
                    	<div class="row">
                        <div class="col-sm-4 col-md-4">
							<div class="pImgViewer"><img src="<?=$ptgdefault?>" data-rollover="" /></div>
						</div>
						<div class="col-sm-8 col-md-8">
                            <div class="row item-head">
                                <div class="col-sm-2 col-md-2"><div class="ihead"><strong>Model</strong></div></div>
                                <div class="col-sm-2 col-md-2"><div class="ihead"><span>Capacity</span><span>(Liters)</span></div></div>
                                <div class="col-sm-2 col-md-2"><div class="ihead"><span>Capacity</span><span>(Gallons)</span></div></div>
                                <div class="col-sm-2 col-md-2"><div class="ihead"><span>Dia.</span><span>(cm)</span></div></div>
                                <div class="col-sm-2 col-md-2"><div class="ihead"><span>Height</span><span>(cm)</span></div></div>
                                <div class="col-sm-2 col-md-2"><div class="ihead"><span>Ladder</span><span>Net</span></div></div>
                            </div>
                            <div class="scroller">
                                <div class="scrollbar"><div class="track"><div class="thumb"><div class="end"></div></div></div></div>
                                <div class="viewport">
                                     <div class="overview">
										<?php
                                        if ( function_exists( 'ot_get_option' ) ) {
                                        $svproducts = ot_get_option( 'ptgal', array() );
                                          if ( ! empty( $svproducts ) ) {
                                            foreach( $svproducts as $svproduct ) {
                                                $ladder = $svproduct['ladder'];
                                                if($ladder == ""){
                                                    $lad = "&nbsp;";
                                                }else{
                                                    $lad = $svproduct['ladder'];
                                                }
                                                echo '								
                                                <ul class="row">
                                                    <li class="col-sm-2 col-md-2" data-rollover="' . $svproduct['ptgimage'] . '"><div class="pitems">' . $svproduct['model'] . '</div></li>
                                                    <li class="col-sm-2 col-md-2" data-rollover="' . $svproduct['ptgimage'] . '"><div class="pitems">' . $svproduct['liters'] . '</div></li>
                                                    <li class="col-sm-2 col-md-2" data-rollover="' . $svproduct['ptgimage'] . '"><div class="pitems">' . $svproduct['gal'] . '</div></li>
                                                    <li class="col-sm-2 col-md-2" data-rollover="' . $svproduct['ptgimage'] . '"><div class="pitems">' . $svproduct['dia'] . '</div></li>
                                                    <li class="col-sm-2 col-md-2" data-rollover="' . $svproduct['ptgimage'] . '"><div class="pitems">' . $svproduct['height'] . '</div></li>
                                                    <li class="col-sm-2 col-md-2" data-rollover="' . $svproduct['ptgimage'] . '"><div class="pitems">' . $lad. '</div></li>
                                                </ul>
                                                ';
                                          }
                                        }
                                        }
                                        ?>
                                	</div>
                                </div>
                            </div><!-- #scroller END -->
                         </div>
                        </div>
                        </div>
                        <div class="all-products">
                            <img src="<?=$ptgwimg?>" />
                        </div>
                        </div>
                        </div>
        </div>
    </div>
</content>
<?php get_footer(); ?>