<?php 
if ( function_exists( 'ot_get_option' ) ) {
  $logo = ot_get_option( 'logo' );
  $facebook = ot_get_option( 'facebook' );
  $twitter = ot_get_option( 'twitter' );
  $gplus = ot_get_option( 'gplus' );
  $favicon = ot_get_option( 'favicon' );
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php bloginfo('name'); ?><?php wp_title(); ?></title>
<link rel="shortcut icon" href="<?=$favicon?>" />
<link href="<?php echo bloginfo('stylesheet_directory');?>/style.css" rel="stylesheet" type="text/css" />
<link href="<?php echo bloginfo('stylesheet_directory');?>/css/tinyscrollbar.css" rel="stylesheet" type="text/css" />
<!--[if lt IE 9]>
<script src="<?php echo bloginfo('stylesheet_directory');?>/js/html5shiv.js"></script>
<script src="<?php echo bloginfo('stylesheet_directory');?>/js/respond.min.js"></script>
<![endif]-->
<?php
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
	wp_head();
?>
</head>

<body>
<header id="floating">
	<div class="wrapper">
    	<div class="row">
          <div class="col-sm-4 col-md-4"><a href="<?php echo bloginfo('url');?>"><img src="<?php echo $logo; ?>" /></a></div>
          <div class="col-sm-8 col-md-8">
              <div class="row">
                  <div class="col-sm-9 col-md-9">
                      <div class="navigation">
                          <div class="hidden-xs"><?php wp_nav_menu( array('menu' => 'Main Menu' )); ?></div>
                          
                          <!-- Mobile Navigation -->
                          <nav class="navbar navbar-default visible-xs" role="navigation">
                              <div class="navbar-header">
                              <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#dwd-collapse">
                              <span class="icon-bar"></span>
                              <span class="icon-bar"></span>
                              <span class="icon-bar"></span>
                              </button>
                              </div>
                              <div class="collapse navbar-collapse" id="dwd-collapse">
                                  <?php /* Primary navigation */
                                    wp_nav_menu( array(
                                      'menu' => 'main',
                                      'depth' => 2,
                                      'container' => false,
                                      'menu_class' => '',
                                      //Process nav menu using our custom nav walker
                                      'walker' => new wp_bootstrap_navwalker())
                                    );
                                    ?>
                              </div>
                          </nav>
                      </div>
                  </div>
                  <div class="col-sm-3 col-md-3">
                      <div class="social-media">
                          <ul>
              <?php if($facebook != ""){?><li><a href="<?php echo $facebook; ?>" target="_blank"><i class="fa fa-facebook"></i></a></li><?php }else{}?>
              <?php if($twitter != ""){?><li><a href="<?php echo $twitter; ?>" target="_blank"><i class="fa fa-twitter"></i></a></li><?php }else{}?>
              <?php if($gplus != ""){?><li><a href="<?php echo $gplus; ?>" target="_blank" rel="publisher"><i class="fa fa-google-plus"></i></a></li><?php }else{}?>
                          </ul>
                      </div>
                  </div>
              </div>
          </div>
        </div>
    </div>
</header>
