<?php

namespace TdySports\InputFilter;

use TdyCommons\InputFilter\BaseInputFilter;
use Zend\InputFilter\Factory as InputFilterFactory;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Validator;

/**
 * Class Standing
 *
 * @package TdySports\InputFilter
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Standing extends BaseInputFilter
{

    /**
     * @param ServiceLocatorInterface $sm
     * @param bool                    $isEdit
     */
    public function __construct($sm, $isEdit = false)
    {
        $this->sm = $sm;

        $factory = new InputFilterFactory();

        $this->add($factory->createInput([
            'name'     => 'id',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'sport-id',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Standing ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Invalid Sport ID.',
                            Validator\Digits::INVALID    => 'Invalid Sport ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'team-id',
            'required'   => false,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('League ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Invalid Team ID.',
                            Validator\Digits::INVALID    => 'Invalid Team ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'league-id',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('League ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Invalid League ID.',
                            Validator\Digits::INVALID    => 'Invalid League ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'wins',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Number of wins is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Invalid number.',
                            Validator\Digits::INVALID    => 'Invalid number.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'losses',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Number of losses is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Invalid number.',
                            Validator\Digits::INVALID    => 'Invalid number.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'ties',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Number of ties is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Invalid number.',
                            Validator\Digits::INVALID    => 'Invalid number.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'percentage',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Percentage is required.'),
            ],
        ]));


    }

}