Role = {
    init: function () {
        jQuery.validator.setDefaults({
            highlight: function (element) {
                jQuery(element).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (element) {
                jQuery(element).closest('.form-group').removeClass('has-error');
            },
            errorElement: 'span',
            errorClass: 'help-block',
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else {
                    error.insertAfter(element);
                }
            }
        });

    },
    refreshCanvas: function (callback) {
        var callback = callback;
        jQuery.ajax({
            xhr: function () {
                var xhr = new window.XMLHttpRequest();
                xhr.addEventListener('progress', function (e) {
                    if (e.lengthComputable) {
                        jQuery(document).skylo('set', (100 * e.loaded / e.total));
                    }
                });
                return xhr;
            },
            url: eDoc.basePath + '/roles',
            beforeSend: function () {
                jQuery(document).skylo('start');
            },
            complete: function (response, status, xhr) {
                jQuery(document).skylo('end');
            },
            success: function (data) {
                jQuery('#role-canvas').html(data);
                window.history.pushState("", "Roles - Users - " + eDoc.title, eDoc.basePath + '/roles');
                jQuery(".alert").delay(3000).fadeOut("slow", function () {
                    jQuery(this).remove();
                });
                callback();
            }
        });
    },
    reload: function (page) {
        jQuery.ajax({
            url: page,
            xhr: function () {
                var xhr = new window.XMLHttpRequest();
                xhr.addEventListener('progress', function (e) {
                    if (e.lengthComputable) {
                        jQuery(document).skylo('set', (100 * e.loaded / e.total));
                    }
                });
                return xhr;
            },
            beforeSend: function () {
                jQuery(document).skylo('start');
            },
            complete: function (response, status, xhr) {
                jQuery(document).skylo('end');
            },
            success: function (data) {
                jQuery('#role-canvas').html(data);
                window.history.pushState("", "Roles - Aboitiz Records Management", page);
                jQuery(".alert").delay(3000).fadeOut("slow", function () {
                    jQuery(this).remove();
                });
            }
        });
    },
    validate: function (action) {
        jQuery('#form-' + action).validate({
            rules: {
                name: {
                    required: true,
                    remote: {
                        url: eDoc.basePath + '/roles/not-exists',
                        data: {
                            exclude: function () {
                                return jQuery('#form-' + action + ' input[name="id"]').val();
                            }
                        },
                        type: 'POST',
                        async: false
                    }
                }
            },
            messages: {
                name: {
                    required: 'This field is required.',
                    remote: jQuery.validator.format('Role Name {0} is already taken.')
                }
            }
        });
        jQuery('#modal-' + action + ' .btn-save i').attr('class', 'fa fa-save');
        jQuery('#modal-' + action + ' .btn-save').removeClass('disabled');
    },
    submit: function (action) {
        jQuery('#form-' + action + '').ajaxSubmit({
            beforeSend: function () {
                jQuery('#modal-' + action + ' .btn-save i').attr('class', 'fa fa-refresh fa-spin');
                jQuery('#modal-' + action + ' .btn-save').addClass('disabled');
            },
            success: function (data) {
                Role.refreshCanvas(function () {
                    jQuery('#modal-' + action + '').modal('hide');
                    jQuery.growl(data.message, { type: 'success' });
                });
            }
        });
    }
};

jQuery(document).ready(function () {

    Role.init();

    // Set Number of Rows Start
    jQuery('body').on('change', 'select[name="l"]', function (e) {
        url = eDoc.basePath + '/roles?l=' + jQuery(this).val();
        q = jQuery('.form-line-search input[name="q"]').val();
        if (q !== '' && q !== undefined) {
            url += '&q=' + q;
        }
        Role.reload(url, true);
    });
    // Set Number of Rows End

    // Seaerch Event Start
    jQuery('body').on('submit', '.form-line-search', function (e) {
        Role.reload(jQuery(this).attr('action') + '?q=' + jQuery('.form-line-search input[name="q"]').val());
        e.preventDefault();
        e.stopPropagation();
        return false;
    });
    // Search Event End

    // Clear Event Start
    jQuery('body').on('click', '.btn-clear', function (e) {
        if (jQuery(this).not('.active')) {
            Role.reload(jQuery(this).attr('href'));
        }
        e.preventDefault();
        return false;
    });
    // Clear Event End

    // Add Start
    jQuery('#modal-add').on('shown.bs.modal', function () {
        Role.validate('add');
    });

    jQuery('#modal-add').on('hidden.bs.modal', function () {
        jQuery(this).removeData('bs.modal');
    });

    jQuery('body').on('click', '#modal-add .btn-save', function () {
        var isValid = jQuery('#form-add').valid();
        if (isValid) {
            Role.submit('add');
        }
    });

    jQuery('body').on('submit', '#modal-add', function (e) {
        e.preventDefault();
        var isValid = jQuery('#form-add').valid();
        if (isValid) {
            Role.submit('add');
        }
    });
    // Add End

    // Edit Start
    jQuery('#modal-edit').on('shown.bs.modal', function () {
        Role.validate('edit');
    });

    jQuery('#modal-edit').on('hidden.bs.modal', function () {
        jQuery(this).removeData('bs.modal');
    });

    jQuery('body').on('click', '#modal-edit .btn-save', function () {
        var isValid = jQuery('#form-edit').valid();
        if (isValid) {
            Role.submit('edit');
        }
    });

    jQuery('body').on('submit', '#modal-edit', function (e) {
        e.preventDefault();
        var isValid = jQuery('#form-edit').valid();
        if (isValid) {
            Role.submit('edit');
        }
    });
    // Edit End

    // Delete Start
    jQuery('#modal-delete').on('hidden.bs.modal', function () {
        jQuery(this).removeData('bs.modal');
    });

    jQuery('body').on('click', '#modal-delete .btn-warning', function (e) {
        jQuery('#form-delete').ajaxSubmit({
            data: {
                delete: 'y'
            },
            beforeSend: function () {
                jQuery('#modal-delete .btn-warning i').attr('class', 'fa fa-refresh fa-spin');
                jQuery('#modal-delete .btn').addClass('disabled');
            },
            success: function (data) {
                Role.refreshCanvas(function () {
                    jQuery('#modal-delete').modal('hide');
                    jQuery.growl(data.message, { type: 'success' });
                });
            }
        });
        e.preventDefault();
    });
    // Delete End

    // Restore Start
    jQuery('#modal-restore').on('hidden.bs.modal', function () {
        jQuery(this).removeData('bs.modal');
    });

    jQuery('body').on('click', '#modal-restore .btn-info', function (e) {
        jQuery('#form-restore').ajaxSubmit({
            data: {
                restore: 'y'
            },
            beforeSend: function () {
                jQuery('#modal-restore .btn-info i').attr('class', 'fa fa-refresh fa-spin');
                jQuery('#modal-restore .btn').addClass('disabled');
            },
            success: function (data) {
                Role.refreshCanvas(function () {
                    jQuery('#modal-restore').modal('hide');
                    jQuery.growl(data.message, { type: 'success' });
                });
            }
        });
        e.preventDefault();
    });
    // Restore End

    // Burn Start
    jQuery('#modal-burn').on('hidden.bs.modal', function () {
        jQuery(this).removeData('bs.modal');
    });

    jQuery('body').on('click', '#modal-burn .btn-danger', function (e) {
        jQuery('#form-burn').ajaxSubmit({
            data: {
                burn: 'y'
            },
            beforeSend: function () {
                jQuery('#modal-burn .btn-danger i').attr('class', 'fa fa-refresh fa-spin');
                jQuery('#modal-burn .btn').addClass('disabled');
            },
            success: function (data) {
                Role.refreshCanvas(function () {
                    jQuery('#modal-burn').modal('hide');
                    jQuery.growl(data.message, { type: 'success' });
                });
            }
        });
        e.preventDefault();
    });
    // Burn End

});
