<?php

namespace TdyCommons\Controller;

use TdyAvatars\Table\Avatars;
use TdyPlayers\Model\Player;
use TdyPlayers\Table\Players;
use TdyCommons\Table\DropdownItems;
use TdyCommons\Table\DropdownLists;
use TdyCommons\Table\Settings;
use TdyGames\Table as Games;
use TdySports\Table\Groups;
use TdySports\Table\Leagues;
use TdySports\Table\Schedules;
use TdySports\Table\Sports;
use TdySports\Table\Standings;
use TdySports\Table\Teams;
use TdySports\Table\Weeks;
use Zend\Log\Logger;

/**
 * Trait BaseControllerTrait
 *
 * @package TdyCommons\Controller
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
trait BaseControllerTrait
{

    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @var DropdownLists
     */
    protected $dropdownListsTable;

    /**
     * @var DropdownItems
     */
    protected $dropdownItemsTable;

    /**
     * @var Players
     */
    protected $playersTable;

    /**
     * @var Sports
     */
    protected $sportsTable;

    /**
     * @var Leagues
     */
    protected $leaguesTable;

    /**
     * @var Groups
     */
    protected $groupsTable;

    /**
     * @var Weeks
     */
    protected $weeksTable;

    /**
     * @var Teams
     */
    protected $teamsTable;

    /**
     * @var Schedules
     */
    protected $schedulesTable;

    /**
     * @var Games\Types
     */
    protected $gameTypesTable;

    /**
     * @var Games\Attributes
     */
    protected $gameAttributesTable;

    /**
     * @var Games\Contests
     */
    protected $contestsTable;

    /**
     * @var Games\Slots
     */
    protected $contestsSlotsTable;

    /**
     * @var Games\Mixtures
     */
    protected $contestsMixturesTable;

    /**
     * @var Avatars
     */
    protected $avatarsTable;

    /**
     * @var Standings
     */
    protected $standingsTable;

    /**
     * @var Settings
     */
    protected $settingsTable;

    /**
     * @var Player
     */
    protected $currentPlayer;

    /**
     * @return Logger
     */
    public function getLogger()
    {
        if (!$this->logger) {
            $sm           = $this->getServiceLocator();
            $this->logger = $sm->get('Logger');
        }

        return $this->logger;
    }

    /**
     * @return DropdownLists
     */
    public function getDropdownListsTable()
    {
        if (!$this->dropdownListsTable) {
            $sm                       = $this->getServiceLocator();
            $this->dropdownListsTable = $sm->get('TdyCommons\Table\DropdownLists');
        }

        return $this->dropdownListsTable;
    }

    /**
     * @return DropdownItems
     */
    public function getDropdownItemsTable()
    {
        if (!$this->dropdownItemsTable) {
            $sm                       = $this->getServiceLocator();
            $this->dropdownItemsTable = $sm->get('TdyCommons\Table\DropdownItems');
        }

        return $this->dropdownItemsTable;
    }

    /**
     * @return Players
     */
    public function getPlayersTable()
    {
        if (!$this->playersTable) {
            $sm                 = $this->getServiceLocator();
            $this->playersTable = $sm->get('TdyPlayers\Table\Players');
        }

        return $this->playersTable;
    }

    /**
     * @return Sports
     */
    public function getSportsTable()
    {
        if (!$this->sportsTable) {
            $sm                = $this->getServiceLocator();
            $this->sportsTable = $sm->get('TdySports\Table\Sports');
        }

        return $this->sportsTable;
    }

    /**
     * @return Leagues
     */
    public function getLeaguesTable()
    {
        if (!$this->leaguesTable) {
            $sm                 = $this->getServiceLocator();
            $this->leaguesTable = $sm->get('TdySports\Table\Leagues');
        }

        return $this->leaguesTable;
    }

    /**
     * @return Groups
     */
    public function getGroupsTable()
    {
        if (!$this->groupsTable) {
            $sm                = $this->getServiceLocator();
            $this->groupsTable = $sm->get('TdySports\Table\Groups');
        }

        return $this->groupsTable;
    }

    /**
     * @return Weeks
     */
    public function getWeeksTable()
    {
        if (!$this->weeksTable) {
            $sm               = $this->getServiceLocator();
            $this->weeksTable = $sm->get('TdySports\Table\Weeks');
        }

        return $this->weeksTable;
    }

    /**
     * @return Teams
     */
    public function getTeamsTable()
    {
        if (!$this->teamsTable) {
            $sm               = $this->getServiceLocator();
            $this->teamsTable = $sm->get('TdySports\Table\Teams');
        }

        return $this->teamsTable;
    }

    /**
     * @return Schedules
     */
    public function getSchedulesTable()
    {
        if (!$this->schedulesTable) {
            $sm                   = $this->getServiceLocator();
            $this->schedulesTable = $sm->get('TdySports\Table\Schedules');
        }

        return $this->schedulesTable;
    }

    /**
     * @return Games\Types
     */
    public function getGameTypesTable()
    {
        if (!$this->gameTypesTable) {
            $sm                   = $this->getServiceLocator();
            $this->gameTypesTable = $sm->get('TdyGames\Table\Types');
        }

        return $this->gameTypesTable;
    }

    /**
     * @return Games\Attributes
     */
    public function getGameAttributesTable()
    {
        if (!$this->gameAttributesTable) {
            $sm                        = $this->getServiceLocator();
            $this->gameAttributesTable = $sm->get('TdyGames\Table\Attributes');
        }

        return $this->gameAttributesTable;
    }

    /**
     * @return Games\Contests
     */
    public function getContestsTable()
    {
        if (!$this->contestsTable) {
            $sm                  = $this->getServiceLocator();
            $this->contestsTable = $sm->get('TdyGames\Table\Contests');
        }

        return $this->contestsTable;
    }

    /**
     * @return Games\Slots
     */
    public function getContestsSlotsTable()
    {
        if (!$this->contestsSlotsTable) {
            $sm                       = $this->getServiceLocator();
            $this->contestsSlotsTable = $sm->get('TdyGames\Table\Contests\Slots');
        }

        return $this->contestsSlotsTable;
    }

    /**
     * @return Games\Mixtures
     */
    public function getContestsMixturesTable()
    {
        if (!$this->contestsMixturesTable) {
            $sm                          = $this->getServiceLocator();
            $this->contestsMixturesTable = $sm->get('TdyGames\Table\Contests\Slots\Mixtures');
        }

        return $this->contestsMixturesTable;
    }

    /**
     * @return Avatars
     */
    public function getAvatarsTable()
    {
        if (!$this->avatarsTable) {
            $sm                 = $this->getServiceLocator();
            $this->avatarsTable = $sm->get('TdyAvatars\Table\Avatars');
        }

        return $this->avatarsTable;
    }

    /**
     * @return Standings
     */
    public function getStandingsTable()
    {
        if (!$this->standingsTable) {
            $sm                   = $this->getServiceLocator();
            $this->standingsTable = $sm->get('TdySports\Table\Standings');
        }

        return $this->standingsTable;
    }

    /**
     * @return Player
     */
    protected function getCurrentPlayer()
    {
        if (!$this->currentPlayer) {
            $sm                  = $this->getServiceLocator();
            $this->currentPlayer = $sm->get('CurrentPlayer');
        }

        return $this->currentPlayer;
    }

    /**
     * @return Settings
     */
    public function getSettingsTable()
    {
        if (!$this->settingsTable) {
            $this->settingsTable = $this->getServiceLocator()->get('TdyCommons\Table\Settings');
        }

        return $this->settingsTable;
    }

}
