<?php

return [
    'router'          => [
        'routes' => [
            'settings'       => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/settings',
                    'defaults' => [
                        'module'     => 'TdyCommons',
                        'controller' => 'TdyCommons\Controller\Settings',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
            ],
            'dropdown-lists' => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/dropdown-lists',
                    'defaults' => [
                        'module'     => 'TdyCommons',
                        'controller' => 'TdyCommons\Controller\Web\DropdownLists',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Web\DropdownLists',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Web\DropdownLists',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Web\DropdownLists',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Rest\DropdownLists',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Web\DropdownLists',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'dropdown-items' => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/dropdown-items',
                    'defaults' => [
                        'module'     => 'TdyCommons',
                        'controller' => 'TdyCommons\Controller\Web\DropdownItems',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Web\DropdownItems',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Web\DropdownItems',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Web\DropdownItems',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Rest\DropdownItems',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdyCommons',
                                'controller' => 'TdyCommons\Controller\Web\DropdownItems',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
        ],
    ],
    'controllers'     => [
        'invokables' => [
            'TdyCommons\Controller\Settings'           => 'TdyCommons\Controller\SettingsController',
            'TdyCommons\Controller\Modules'            => 'TdyCommons\Controller\ModulesController',
            'TdyCommons\Controller\Web\DropdownLists'  => 'TdyCommons\Controller\Web\DropdownListsController',
            'TdyCommons\Controller\Rest\DropdownLists' => 'TdyCommons\Controller\Rest\DropdownListsController',
            'TdyCommons\Controller\Countries'          => 'TdyCommons\Controller\CountriesController',
            'TdyCommons\Controller\Divisions'          => 'TdyCommons\Controller\DivisionsController',
            'TdyCommons\Controller\Localities'         => 'TdyCommons\Controller\LocalitiesController',
        ],
    ],
    'view_manager'    => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
            //'ViewPdfStrategy',
            //'ViewXlsxStrategy',
        ],
    ],
    'service_manager' => [
        'aliases'   => [
            //'ViewPdfStrategy'  => 'TdyCommons\View\Strategy\PdfStrategy',
            //'ViewPdfRenderer'  => 'TdyCommons\View\Renderer\PdfRenderer',
            //'ViewXlsxStrategy' => 'TdyCommons\View\Strategy\XlsxStrategy',
            //'ViewXlsxRenderer' => 'TdyCommons\View\Renderer\XlsxRenderer',
        ],
        'factories' => [
            //'TdyCommons\Mail'                       => 'TdyCommons\Mail\MailFactory',
            //'TdyCommons\View\Strategy\PdfStrategy'  => 'TdyCommons\View\Factory\PdfStrategyFactory',
            //'TdyCommons\View\Renderer\PdfRenderer'  => 'TdyCommons\View\Factory\PdfRendererFactory',
            //'TdyCommons\View\Strategy\XlsxStrategy' => 'TdyCommons\View\Factory\XlsxStrategyFactory',
            //'TdyCommons\View\Renderer\XlsxRenderer' => 'TdyCommons\View\Factory\XlsxRendererFactory',
        ],
    ],
];
