<?php

namespace TdyAvatars;

use TdyGames\Model\Mixture;
use TdyGames\Model\Slot;
use Zend\Authentication\Adapter as AuthAdapter;
use Zend\Authentication\Storage;
use Zend\Db\Adapter\Adapter as DbAdapter;
use Zend\Db\ResultSet\HydratingResultSet;
use Zend\Db\TableGateway\TableGateway;
use Zend\Di\ServiceLocatorInterface;
use Zend\ModuleManager\Feature\AutoloaderProviderInterface;
use Zend\ModuleManager\Feature\ConfigProviderInterface;
use Zend\ModuleManager\Feature\ServiceProviderInterface;
use Zend\ModuleManager\Feature\ViewHelperProviderInterface;
use Zend\Session;

class Module implements AutoloaderProviderInterface, ConfigProviderInterface, ServiceProviderInterface, ViewHelperProviderInterface
{

    public function getConfig()
    {
        $general = include __DIR__ . '/config/general.php';
        $db      = include __DIR__ . '/config/db.php';

        return array_merge($general, $db);
    }

    public function getAutoloaderConfig()
    {
        return [
            'Zend\Loader\StandardAutoloader' => [
                'namespaces' => [
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ],
            ],
        ];
    }

    public function getViewHelperConfig()
    {
        return [];
    }

    public function getServiceConfig()
    {
        return [
            'factories' => [

                'TdyAvatars\Table\Avatars' => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['avatars']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['avatars']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Avatar());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Avatars($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
            ],
        ];
    }

}