<?php

namespace TdySports\Model;

use TdyCommons\Filter\Word\LowercaseFirst;
use TdyCommons\Model\Model;
use TdySports\Table\Leagues;
use TdySports\Table\Seasons;
use TdySports\Table\Sports;
use Zend\Filter\FilterChain;
use Zend\Filter\Word\DashToCamelCase;
use Zend\Filter\Word\UnderscoreToCamelCase;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\ServiceManager\ServiceManager;

/**
 * Class Week
 *
 * @package TdySports\Model
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Week extends Model
{

    /**
     * The unique ID for Sport.
     *
     * @var int
     */
    public $id = 0;

    /**
     * @var int
     */
    public $sportId = 0;

    /**
     * @var int
     */
    public $leagueId = 0;

    /**
     * @var int
     */
    public $seasonId = 0;

    /**
     * @var string
     */
    public $slug = '';

    /**
     * @var int
     */
    public $number = 0;

    /**
     * @var string
     */
    public $name = '';

    /**
     * @var int
     */
    public $isCurrent = 0;

    /**
     * @var null|ServiceManager|ServiceLocatorInterface
     */
    protected $sm;

    /**
     * @param null $data
     * @param null $sm
     */
    public function __construct($data = null, $sm = null)
    {
        if (!empty($data) && is_array($data)) {
            $this->exchangeArray($data);
        }

        $this->sm = $sm;
    }

    /**
     * @param null|ServiceManager|ServiceLocatorInterface $sm
     */
    public function setServiceLocator($sm)
    {
        $this->sm = $sm;
    }

    /**
     * @see Model::exchangeArray()
     *
     * @param array $data
     */
    public function exchangeArray($data)
    {
        parent::exchangeArray($data);

        foreach ($data as $key => $value) {
            $filter = new FilterChain();
            if (strpos($key, '-') !== false) {
                $filter->attach(new DashToCamelCase());
            } else {
                $filter->attach(new UnderscoreToCamelCase());
            }

            $filter->attach(new LowercaseFirst());
            $nKey = $filter->filter($key);

            if (!property_exists(__CLASS__, $nKey)) {
                continue;
            } else {
                $inArray = in_array($nKey, ['id', 'sport-id', 'league-id', 'number']);
                if ($inArray) {
                    $this->$nKey = (int) $value;
                } else {
                    $this->$nKey = $value;
                }
            }
        }
    }


    /**
     * @return null|Sport
     */
    public function getSport()
    {
        if (is_null($this->sm)) {
            return null;
        }

        /**
         * @var Sports $table
         * @var Sport  $sport
         */
        $table = $this->sm->get('TdySports\Table\Sports');
        $sport = $table->get($this->sportId);

        return $sport;
    }

    /**
     * @return null|League
     */
    public function getLeague()
    {
        if (is_null($this->sm)) {
            return null;
        }

        /**
         * @var Leagues $table
         * @var League  $sport
         */
        $table  = $this->sm->get('TdySports\Table\Leagues');
        $league = $table->get($this->leagueId);

        return $league;
    }

    /**
     * @return null|Sport
     */
    public function getSeason()
    {
        if (is_null($this->sm)) {
            return null;
        }

        /**
         * @var Seasons $table
         * @var Season  $sport
         */
        $table  = $this->sm->get('TdySports\Table\Seasons');
        $season = $table->get($this->seasonId);

        return $season;
    }

    /**
     * @return \StdClass
     */
    public function toStdClass()
    {
        $object = parent::toStdClass();

        if (is_null($this->sm)) {
            return $object;
        }

        unset($object->sportId);

        $sport         = $this->getSport();
        $object->sport = $sport->toStdClass();

        unset($object->leagueId);

        $league         = $this->getLeague();
        $object->league = $league->toStdClass();

        $season         = $this->getSeason();
        $object->season = $season->toStdClass();

        return $object;
    }

}
