<?php

return [
    'router'       => [
        'routes' => [
            'players' => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/players',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Web\Players',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'   => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Web\Players',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Web\Players',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'    => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Rest\Players',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'    => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Web\Players',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
        ],
    ],
    'controllers'  => [
        'invokables' => [
            'TdyPlayers\Controller\Web\Players'  => 'TdyPlayers\Controller\Web\PlayersController',
            'TdyPlayers\Controller\Rest\Players' => 'TdyPlayers\Controller\Rest\PlayersController',
        ],
    ],
    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies'          => [
            'ViewJsonStrategy',
        ],
    ],

];
