<?php

namespace TdyCommons\View\Helper;

use Zend\Mvc\Router\RouteMatch;
use Zend\View\Helper\AbstractHelper;

/**
 * Class RouteParam
 * @package TdyCommons\View\Helper
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class RouteParam extends AbstractHelper
{

    /**
     * @var RouteMatch
     */
    protected $routeMatch;

    /**
     * @param $routeMatch
     *
     * @return $this
     */
    public function setRouteMatch($routeMatch)
    {
        $this->routeMatch = $routeMatch;

        return $this;
    }

    /**
     * @param string $param
     * @param bool   $toLowerCase
     *
     * @return string
     */
    public function __invoke($param = 'module', $toLowerCase = true)
    {
        if ($this->routeMatch) {
            $value = $this->routeMatch->getParam($param, 'index');
            if ($toLowerCase) {
                $value = strtolower($value);
            }

            return $value;
        } else {
            return '';
        }
    }

}
