<?php

namespace TdyCommons\Model;

use TdyCommons\Filter\Word\LowercaseFirst;
use Zend\Filter\FilterChain;
use Zend\Filter\Word\DashToCamelCase;
use Zend\Filter\Word\UnderscoreToCamelCase;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * The DropdownList model class.
 *
 * @author James Lloyd Atwil <james@nadows.com>
 */
class DropdownList extends Model
{
    /**
     * The List ID.
     *
     * @var int
     */
    public $id = 0;

    /**
     * List slug.
     *
     * @var string
     */
    public $slug = '';

    /**
     * The name of the List.
     *
     * @var string
     */
    public $name = '';

    /**
     * Description of List
     *
     * @var string
     */
    public $description = '';

    /**
     * DropdownList constructor.
     *
     * @param array $data
     */
    public function __construct($data = null)
    {
        if (!empty($data) && is_array($data)) {
            $this->exchangeArray($data);
        }
    }

    /**
     * @see Model::exchangeArray();
     *
     * @param array $data
     */
    public function exchangeArray($data)
    {
        foreach ($data as $key => $value) {
            $filter = new FilterChain();
            if (strpos($key, '-') !== false) {
                $filter->attach(new DashToCamelCase());
            } else {
                $filter->attach(new UnderscoreToCamelCase());
            }

            $filter->attach(new LowercaseFirst());
            $nKey = $filter->filter($key);

            if (!property_exists(__CLASS__, $nKey)) {
                continue;
            } else {
                if ($nKey == 'id') {
                    $this->$nKey = (int) $value;
                } else {
                    $this->$nKey = $value;
                }
            }
        }
        parent::exchangeArray($data);
    }

}
