<?php

namespace TdyCommons\Mail;

use Zend\Mail\Message;
use Zend\Mail\Transport;

/**
 * Class Mail
 * @package TdyCommons\Mail
 *
 * Class for sending messages via emails in different transportation.
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Mail
{

    /**
     * Mail transportation.
     *
     * @var Transport\TransportInterface
     */
    protected $transport = null;

    /**
     * @param array $settings
     *
     * @throws \Exception
     */
    public function __construct($settings)
    {
        $trans = isset($settings['transport']) ? $settings['transport'] : null;
        switch ($trans) {
            case 'smtp': // Using SMTP as transport
                if (!isset($settings['config'])) {
                    throw new \Exception('You must provide configuration on SMTP.');
                }
                $options         = new Transport\SmtpOptions($settings['config']);
                $this->transport = new Transport\Smtp($options);
                break;
            case 'sendmail': // Using Sendmail as transport
                $this->transport = new Transport\Sendmail();
                break;
            case null:
            default: // Disable mail
                $this->transport = new Transport\Null();
        }
    }

    /**
     * Send message.
     *
     * @param Message $message
     */
    public function send(Message $message)
    {
        if (!is_null($this->transport)) {
            $this->transport->send($message);
        }
    }

}