<?php

namespace TdyAdmins\InputFilter;

use TdyCommons\InputFilter\BaseInputFilter;
use Zend\InputFilter\Factory as InputFilterFactory;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Validator;

/**
 * Class Admin
 *
 * @package TdyAdmins\InputFilter
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Admin extends BaseInputFilter
{

    /**
     * @param ServiceLocatorInterface $sm
     * @param bool                    $isEdit
     */
    public function __construct($sm, $isEdit = false)
    {
        $this->sm = $sm;

        $factory = new InputFilterFactory();

        $this->add($factory->createInput([
            'name'     => 'id',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'username',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Username is required.'),
                [
                    'name'    => '\Zend\Validator\Db\NoRecordExists',
                    'options' => [
                        'adapter'                => $this->sm->get('db-01'),
                        'table'                  => $this->sm->get('Config')['mappings']['views']['admins_active']['name'],
                        'field'                  => $this->sm->get('Config')['mappings']['views']['admins_active']['columns']['username'],
                        'exclude'                => [
                            'field' => $this->sm->get('Config')['mappings']['views']['admins_active']['columns']['id'],
                            'value' => $this->data['id']
                        ],
                        'encoding'               => 'UTF-8',
                        'messages'               => [
                            Validator\Db\NoRecordExists::ERROR_RECORD_FOUND => 'Username is already taken.'
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'password',
            'required'   => !$isEdit,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Password is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'lastName',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Last Name is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'firstName',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('First Name is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'     => 'middleName',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'     => 'suffix',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'nickname',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Nickname is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'email',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Email Address is required.'),
                [
                    'name'    => '\Zend\Validator\Db\NoRecordExists',
                    'options' => [
                        'adapter'                => $this->sm->get('db-01'),
                        'table'                  => $this->sm->get('Config')['mappings']['views']['admins_active']['name'],
                        'field'                  => $this->sm->get('Config')['mappings']['views']['admins_active']['columns']['email'],
                        'exclude'                => [
                            'field' => $this->sm->get('Config')['mappings']['views']['admins_active']['columns']['id'],
                            'value' => $this->data['id']
                        ],
                        'encoding'               => 'UTF-8',
                        'messages'               => [
                            Validator\Db\NoRecordExists::ERROR_RECORD_FOUND => 'Email address is already taken.'
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ],
                [
                    'name'    => '\Zend\Validator\EmailAddress',
                    'options' => [
                        'encoding'               => 'UTF-8',
                        'messages'               => [
                            Validator\EmailAddress::INVALID            => 'Email address is invalid.',
                            Validator\EmailAddress::INVALID_FORMAT     => 'Email address has invalid format.',
                            Validator\EmailAddress::INVALID_HOSTNAME   => 'Email address has invalid hostname.',
                            Validator\EmailAddress::INVALID_LOCAL_PART => 'Email address has invalid local part.',
                            Validator\EmailAddress::INVALID_SEGMENT    => 'Email address has invalid segment.',
                            Validator\EmailAddress::INVALID_MX_RECORD  => 'Email address has invalid MX Record.'
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ],
            ],
        ]));

    }

}