<?php

return array(
    'router'          => array(
        'routes' => array(
            'home' => array(
                'type'    => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route'    => '/',
                    'defaults' => array(
                        'module'        => 'Application',
                        'controller'    => 'Application\Controller\Index',
                        'action'        => 'index',
                    ),
                ),
            ),
        ),
    ),
    'controllers'     => array(
        'invokables' => array(
            'Application\Controller\Index' => 'Application\Controller\IndexController',
        ),
    ),
    'view_manager'    => array(
        'display_not_found_reason' => true,
        'display_exceptions'       => true,
        'doctype'                  => 'HTML5',
        'not_found_template'       => 'error/404',
        'exception_template'       => 'error/index',
        'template_map'             => array(
            'layout/layout'          => __DIR__ . '/../view/layout/layout.phtml',
            'partial/page/head'      => __DIR__ . '/../view/partial/page-head.phtml',
            'partial/page/foot'      => __DIR__ . '/../view/partial/page-foot.phtml',
            'partial/section/header' => __DIR__ . '/../view/partial/section-header.phtml',
            'partial/section/footer' => __DIR__ . '/../view/partial/section-footer.phtml',
            'error/404'              => __DIR__ . '/../view/error/404.phtml',
            'error/index'            => __DIR__ . '/../view/error/index.phtml',
        ),
        'template_path_stack'      => array(
            __DIR__ . '/../view',
        ),
    ),
);
