<?php 
/*
Template Name:  Homepage
 * @name		Homepage
 * @type		PHP page
 * @desc		Homepage

*/
get_header();
?>
<section id="slider">
    <div class="slides">
        <div class="cycle-slideshow" 
            data-cycle-fx=fadeIn
            data-cycle-timeout=0
            data-cycle-prev="#prev"
            data-cycle-next="#next"
            data-cycle-slides="> div"
            >
          <span class="cycle-pager"></span>
          <?php
              if ( function_exists( 'ot_get_option' ) ) {
                  $slides = ot_get_option( 'my_slider', array() );
                      if ( ! empty( $slides ) ) {
                        foreach( $slides as $slide ) {
                            echo '<div class="sItem">
                            <span class="sl-details hidden-xs">
                                <h2>' . $slide['title'] . '</h2>
                                <p>' . $slide['slider_description'] . '</p>
                            </span>
                            <a href="' . $slide['slider_link'] . '"><img src="' . $slide['slider_image'] . '" alt="' . $slide['title'] . '" /></a>
                            </div>';
                      }
                  }
              }
              ?>
        </div>
        <div id="prev"><i class="fa fa-angle-left fa-4x"></i></div>
        <div id="next"><i class="fa fa-angle-right fa-4x"></i></div>
    </div>
</section>

<content>
	<div class="wrapper">
        <div class="home-blocks">
            <div class="row">
				<?php
              if ( function_exists( 'ot_get_option' ) ) {
                  $hblocks = ot_get_option( 'home_block', array() );
                      if ( ! empty( $slides ) ) {
                        foreach( $hblocks as $hblock ) {
                            echo '<div class="col-sm-3 col-md-3">
							<a href="' . $hblock['block_link'] . '"><img src="' . $hblock['block_image'] . '" alt="' . $hblock['title'] . '" />
							<h2>' . $hblock['title'] . '</h2></a>
                            </div>';
                      }
                  }
              }
              ?>
            </div>
        </div>
    </div>
</content>
<?php get_footer(); ?>