<?php
// Register custom navigation walker
require_once('includes/wp_bootstrap_navwalker.php');
add_filter( 'ot_show_pages', '__return_false' );
add_filter( 'ot_theme_mode', '__return_true' );
 
include_once( 'option-tree/ot-loader.php' );
include_once( 'includes/theme-options.php' );

if (!session_id())
session_start();

// ***************************  Handle Widget Areas  ******************************* //

function ryan_widgets_init() {
		
		register_sidebar( array(
			'name' => __( 'Sidebar', 'twentyten' ),
			'id' => 'sidebar',
			'description' => __( 'This is displayed on the all pages', 'twentyten' ),
			'before_widget' => '',
			'after_widget' => '',
			'before_title' => '<h3>',
			'after_title' => '</h3>',
		) );
}

/** Register sidebars by running twentyten_widgets_init() on the widgets_init hook. */
add_action( 'widgets_init', 'ryan_widgets_init' );

add_theme_support( 'nav-menus' );

function get_current_user_role() {
    global $current_user;
    get_currentuserinfo();
    $user_roles = $current_user->roles;
    $user_role = array_shift($user_roles);
    return $user_role;
};

// ***************************  Setup Thumbnail  ****************************** //

if ( function_exists( 'add_theme_support' ) ) {

    add_theme_support( 'post-thumbnails' );
    set_post_thumbnail_size( 300, 199, true ); // Normal post thumbnails
    add_image_size( 'featured-image', 451, 391, true );
    add_image_size( 'slider', 451, 391, false );
    add_image_size( 'featured', 958, 348, true );

}

// ***************************  Custom User Fields  ****************************** //

function admin_del_options() {
   global $_wp_admin_css_colors;
   $_wp_admin_css_colors = 0;
}

add_action('admin_head', 'admin_del_options');

function rb_new_contactmethods( $contactmethods ) {
    // Remove Garbage
	unset($contactmethods['aim']);
	unset($contactmethods['jabber']);
	unset($contactmethods['yim']);

    return $contactmethods;
}
add_filter('user_contactmethods','rb_new_contactmethods',10,1);
function string_limit_words($string, $word_limit)
{
  $words = explode(' ', $string, ($word_limit + 1));
  if(count($words) > $word_limit)
  array_pop($words);
  return implode(' ', $words);
}

function add_page_excerpt_support(){
   add_post_type_support( 'page', 'excerpt' );
}
 
add_action('admin_init', 'add_page_excerpt_support');

function register_my_menus() {
  register_nav_menus(
    array( 'header-menu' => __( 'Header Menu' ) )
  );
}
add_action( 'init', 'register_my_menus' );

add_filter( 'wp_nav_menu_objects', 'add_menu_parent_class' );
function add_menu_parent_class( $items ) {
	
	$parents = array();
	foreach ( $items as $item ) {
		if ( $item->menu_item_parent && $item->menu_item_parent > 0 ) {
			$parents[] = $item->menu_item_parent;
		}
	}
	
	foreach ( $items as $item ) {
		if ( in_array( $item->ID, $parents ) ) {
			$item->classes[] = 'menu-parent-item'; 
		}
	}
	
	return $items;    
}

function new_excerpt_more($more) {
global $post;
	return '… <a href="'. get_permalink($post->ID) . '">' . 'read more' . '</a>';
}
add_filter('excerpt_more', 'new_excerpt_more');

if ( ! function_exists( 'my_pagination' ) ) :
	function my_pagination() {
		global $wp_query;

		$big = 999999999; // need an unlikely integer
		
		echo paginate_links( array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'total' => $wp_query->max_num_pages
		) );
	}
endif;
?>
