<?php

// Register Custom Post Type
function ftank_products_posttype() {

	$labels = array(
		'name'                => _x( 'Products', 'Post Type General Name', 'firstank' ),
		'singular_name'       => _x( 'Product', 'Post Type Singular Name', 'firstank' ),
		'menu_name'           => __( 'Products', 'firstank' ),
		'parent_item_colon'   => __( 'Parent Product:', 'firstank' ),
		'all_items'           => __( 'All Products', 'firstank' ),
		'view_item'           => __( 'View Product', 'firstank' ),
		'add_new_item'        => __( 'Add New Product', 'firstank' ),
		'add_new'             => __( 'Add New', 'firstank' ),
		'edit_item'           => __( 'Edit Product', 'firstank' ),
		'update_item'         => __( 'Update Product', 'firstank' ),
		'search_items'        => __( 'Search Product', 'firstank' ),
		'not_found'           => __( 'Not found', 'firstank' ),
		'not_found_in_trash'  => __( 'Not found in Trash', 'firstank' ),
	);
	$args = array(
		'labels'              => $labels,
		'supports'            => array( 'title', 'thumbnail', 'custom-fields', ),
		'hierarchical'        => false,
		'public'              => false,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'menu_position'       => 5,
		'can_export'          => true,
		'has_archive'         => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
	);
	register_post_type( 'product', $args );

}

// Hook into the 'init' action
add_action( 'init', 'ftank_products_posttype', 0 );

// Register Custom Taxonomy
function ftank_prodtype_taxonomy() {

	$labels = array(
		'name'                       => _x( 'Types', 'Taxonomy General Name', 'firstank' ),
		'singular_name'              => _x( 'Type', 'Taxonomy Singular Name', 'firstank' ),
		'menu_name'                  => __( 'Type', 'firstank' ),
		'all_items'                  => __( 'All Type', 'firstank' ),
		'parent_item'                => __( 'Parent Type', 'firstank' ),
		'parent_item_colon'          => __( 'Parent Type:', 'firstank' ),
		'new_item_name'              => __( 'New Type Name', 'firstank' ),
		'add_new_item'               => __( 'Add New Type', 'firstank' ),
		'edit_item'                  => __( 'Edit Type', 'firstank' ),
		'update_item'                => __( 'Update Type', 'firstank' ),
		'separate_items_with_commas' => __( 'Separate type with commas', 'firstank' ),
		'search_items'               => __( 'Search types', 'firstank' ),
		'add_or_remove_items'        => __( 'Add or remove types', 'firstank' ),
		'choose_from_most_used'      => __( 'Choose from the most used types', 'firstank' ),
		'not_found'                  => __( 'Not Found', 'firstank' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => false,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => false,
		'show_tagcloud'              => false,
	);
	register_taxonomy( 'type', array( 'product' ), $args );

}

// Hook into the 'init' action
add_action( 'init', 'ftank_prodtype_taxonomy', 0 );