<?php  

/**
 * Initialize the options before anything else. 
 */
add_action( 'admin_init', 'custom_theme_options', 1 );

/**
 * Build the custom settings & update OptionTree.
 */
function custom_theme_options() {
  /**
   * Get a copy of the saved settings array. 
   */
  $saved_settings = get_option( 'option_tree_settings', array() );
  
  /**
   * Custom settings array that will eventually be 
   * passes to the OptionTree Settings API Class.
   */
  $custom_settings = array(
    'sections'        => array(
      array(
        'id'          => 'general',
        'title'       => 'General'
      ),
      array(
        'id'          => 'socialmedia',
        'title'       => 'Social Media'
      ),
      array(
        'id'          => 'slideshow',
        'title'       => 'Slider'
      ),
      array(
        'id'          => 'blocks',
        'title'       => 'Homepage Blocks'
      ),
      array(
        'id'          => 'about',
        'title'       => 'About Us Slider'
      ),
      array(
        'id'          => 'services',
        'title'       => 'Services'
      ),
      array(
        'id'          => 'contact',
        'title'       => 'Contact Us'
      ),
      array(
        'id'          => 'luzon',
        'title'       => 'Luzon'
      ),
      array(
        'id'          => 'visayas',
        'title'       => 'Visayas'
      ),
      array(
        'id'          => 'mindanao',
        'title'       => 'Mindanao'
      ),
      array(
        'id'          => 'stainless',
        'title'       => 'Stainless Storage Tank'
      ),
      array(
        'id'          => 'poly',
        'title'       => 'Polyethelyne Storage Tank'
      ),
      array(
        'id'          => 'custom',
        'title'       => 'Customize Tank'
      ),
      array(
        'id'          => 'press',
        'title'       => 'Pressure Tank Stainless'
      ),
      array(
        'id'          => 'galvan',
        'title'       => 'Pressure Tank Galvanize'
      )
    ),
    'settings'        => array(
	   array(
        'id'          => 'favicon',
        'label'       => 'Favicon',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'class'       => '',
        'choices'     => array(),
      ),
	   array(
        'id'          => 'logo',
        'label'       => 'Logo',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'class'       => '',
        'choices'     => array(),
      ),
	   array(
        'id'          => 'phone',
        'label'       => 'Phone Number',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'general',
        'class'       => '',
        'choices'     => array(),
      ),
      array(
        'id'          => 'my_slider',
        'label'       => 'Slider Images',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'slideshow',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'slider_image',
            'label'   => 'Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'slider_link',
            'label'   => 'Link to Post',
            'desc'    => 'Enter the posts url.',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'slider_description',
            'label'   => 'Description',
            'desc'    => 'This text is used to add fancy captions in the slider.',
            'std'     => '',
            'type'    => 'textarea',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'aslider',
        'label'       => 'About Us Slider Images',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'about',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'aslider_image',
            'label'   => 'Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'home_block',
        'label'       => 'Homepage Blocks',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'blocks',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'block_image',
            'label'   => 'Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'block_link',
            'label'   => 'Link to Post',
            'desc'    => 'Enter the posts url.',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'sblock',
        'label'       => 'Service Items',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'services',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'block_image',
            'label'   => 'Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'block_desciption',
            'label'   => 'Description',
            'desc'    => 'Enter service item description.',
            'std'     => '',
            'type'    => 'textarea',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'facebook',
        'label'       => 'Facebook',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'socialmedia',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'twitter',
        'label'       => 'Twitter',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'socialmedia',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'gplus',
        'label'       => 'Google Plus',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'socialmedia',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'gmap',
        'label'       => 'Map Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'contact',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'verb',
        'label'       => 'Verbage',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'contact',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'formcode',
        'label'       => 'Form Shortcode',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'contact',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'laddress',
        'label'       => 'Luzon Address',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'luzon',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'address',
            'label'   => 'Address',
            'desc'    => 'Enter Address of the Branch.',
            'std'     => '',
            'type'    => 'textarea',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'vaddress',
        'label'       => 'Visayas Address',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'visayas',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'address',
            'label'   => 'Address',
            'desc'    => 'Enter Address of the Branch.',
            'std'     => '',
            'type'    => 'textarea',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'maddress',
        'label'       => 'Mindanao Address',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'mindanao',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'address',
            'label'   => 'Address',
            'desc'    => 'Enter Address of the Branch.',
            'std'     => '',
            'type'    => 'textarea',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'svdefault',
        'label'       => 'Vertical Default Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'stainless',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'svproduct',
        'label'       => 'Vertical',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'stainless',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'svimage',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'model',
            'label'   => 'Model',
            'desc'    => 'Product Model Number',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'liters',
            'label'   => 'Liters',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'gal',
            'label'   => 'Gallons',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'dia',
            'label'   => 'Diameter',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'height',
            'label'   => 'Height',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'ladder',
            'label'   => 'Ladder',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'shdefault',
        'label'       => 'Horizontal Default Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'stainless',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'shproduct',
        'label'       => 'Horizontal',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'stainless',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'shimage',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'model',
            'label'   => 'Model',
            'desc'    => 'Product Model Number',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'liters',
            'label'   => 'Liters',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'gal',
            'label'   => 'Gallons',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'dia',
            'label'   => 'Diameter',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'lenght',
            'label'   => 'Length',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'height',
            'label'   => 'Height',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'ladder',
            'label'   => 'Ladder',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'swholeimage',
        'label'       => 'All Stainless Product Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'stainless',
        'class'       => '',
        'choices'     => array(),
	  ),
	  /*Poly*/
      array(
        'id'          => 'pvdefault',
        'label'       => 'Vertical Default Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'poly',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'pvproduct',
        'label'       => 'Vertical',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'poly',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'pvimage',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'model',
            'label'   => 'Model',
            'desc'    => 'Product Model Number',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'dia',
            'label'   => 'Diameter',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'h1',
            'label'   => 'h1',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'h2',
            'label'   => 'h2',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'height',
            'label'   => 'Height',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'inner',
            'label'   => 'Inner',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'thick',
            'label'   => 'Thickness',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'phdefault',
        'label'       => 'Horizontal Default Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'poly',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'phproduct',
        'label'       => 'Horizontal',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'poly',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'phimage',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'model',
            'label'   => 'Model',
            'desc'    => 'Product Model Number',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'length',
            'label'   => 'Length',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'width',
            'label'   => 'Width',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'height',
            'label'   => 'Height',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'thick',
            'label'   => 'Thickness',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'pwimage',
        'label'       => 'All Polyethelyne Product Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'poly',
        'class'       => '',
        'choices'     => array(),
	  ),
	  /*Customize*/
      array(
        'id'          => 'cproduct',
        'label'       => 'Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'custom',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'cpimage',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'consite',
        'label'       => 'On-site Fabrication',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'custom',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'cosimg',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'ccone',
        'label'       => 'Cone Type',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'custom',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'ccoimg',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'cflat',
        'label'       => 'Flat Type',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'custom',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'cflimg',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'cbullet',
        'label'       => 'Bullet Type',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'custom',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'cbuimg',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
	  /*PT Stainless*/
      array(
        'id'          => 'ptsdefault',
        'label'       => 'Stainless Default Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'press',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'ptstain',
        'label'       => 'Pressure Tank Stainless',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'press',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'ptsimage',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'model',
            'label'   => 'Model',
            'desc'    => 'Product Model Number',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'liters',
            'label'   => 'Liters',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'gal',
            'label'   => 'Gallons',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'dia',
            'label'   => 'Diameter',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'height',
            'label'   => 'Height',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'ladder',
            'label'   => 'Ladder',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'ptswimg',
        'label'       => 'All Stainless Product Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'press',
        'class'       => '',
        'choices'     => array(),
	  ),
	  /*PT GI*/
      array(
        'id'          => 'ptgdefault',
        'label'       => 'Galvanize/G.I. Default Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'galvan',
        'class'       => '',
        'choices'     => array(),
	  ),
      array(
        'id'          => 'ptgal',
        'label'       => 'Pressure Tank Stainless',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'galvan',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'ptgimage',
            'label'   => 'Product Image',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'model',
            'label'   => 'Model',
            'desc'    => 'Product Model Number',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'liters',
            'label'   => 'Liters',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'gal',
            'label'   => 'Gallons',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'dia',
            'label'   => 'Diameter',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'height',
            'label'   => 'Height',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'ladder',
            'label'   => 'Ladder',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
      ),
      array(
        'id'          => 'ptgwimg',
        'label'       => 'All Galvanize(G.I.) Product Image',
        'desc'        => '',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'galvan',
        'class'       => '',
        'choices'     => array(),
	  )
    )
  );
  
  /* settings are not the same update the DB */
  if ( $saved_settings !== $custom_settings ) {
    update_option( 'option_tree_settings', $custom_settings ); 
  }
  
}

?>