<?php
/*
Template Name: Stainless Products
*/
get_header(); ?>
<main class="stainless-products product-splash">
	<nav class="product-nav">
		<div class="container">
			<div class="span6 push6">
				<a class="current" href="<?php bloginfo('url'); ?>/products/stainless-steel-tanks/">Our Stainless Steel Tanks</a>
				<a href="<?php bloginfo('url'); ?>/products/polyethelyne-tanks/">Our Polyethelyne Tanks</a>
				<div class="clear"></div>
			</div>
		</div>
	</nav>
	<div id="product-pager" class="cycle-nav container">
		<span class="cycle-prev"></span>
    	<span class="cycle-next"></span>
   	</div>
	<div class="cycle-slideshow" data-cycle-slides="> div" data-cycle-fx=scrollHorz data-cycle-timeout=0 data-cycle-pager="#product-pager" data-cycle-pager-template="">
		<div class="featured">
		<?php while( have_posts() ): the_post(); ?>
			<div class="container">
				<div class="span6 push6">
					<article class="hentry">
						<h1 class="title">Stainless Steel Tanks</h1>
						<section class="entry">
							<p class="description">Stainless steel is a durable and cost-efficient choice for your water storage system needs. It is food-grade  and requires low maintenance. We use the thickest material stainless steel grade 304BA, to ensure that water is sourced and stored rust free and safe.</p>
						</section>
						<section class="specs">
							<span>Food Grade</span>
							<span>Durable</span>
							<span>Light-Weight</span>
							<span>Corrosion Resistant</span>
							<span>Easy Maintenance</span>
						</section>
					</article>
				</div>
				<div class="clear"></div>
			</div>
		<?php endwhile; ?>
		</div>
		<?php
			$type = array( array( 'taxonomy' => 'type', 'field' => 'slug', 'terms' => 'stainless-steel' ) );
			$products = new WP_Query( array( 'post_type' => 'product', 'posts_per_page' => -1, 'ignore_sticky_posts' => true, 'tax_query' => $type ) );
		?>
		<div class="product-list">
			<div class="container">
				<?php get_template_part('templates/tools', 'conversion'); ?>
				<?php while ($products->have_posts() ): $products->the_post(); ?>
					<div class="span3">
						<?php
							$capacity = get_post_meta( get_the_ID(), 'product_capacity', true);
							$size = get_post_meta( get_the_ID(), 'product_size', true);
						?>
						<article id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
							<header>
								<a href="javascript:void(0);">
									<span class="photo">
										<?php the_post_thumbnail('full'); ?>
									</span>
									<h2 class="name"><?php the_title(); ?></h2>
								</a>
							</header>
							<section class="entry">
								<p>Capacity: <?php echo get_array_index($capacity, 'liters'); ?> L / <?php echo get_array_index($capacity, 'gallons'); ?> gal</p>
								<p>Size: <?php echo get_array_index($capacity, 'diameter'); ?> cm dia x <?php echo get_array_index($capacity, 'height'); ?> cm h</p>
							</section>
							<section class="slider-img">
							<?php
								$sImages = get_post_meta(get_the_ID(), 'product_slide_img', false);
								foreach($sImages as $sImage):
									echo wp_get_attachment_image( $sImage, 'full' );
								endforeach;
							?>
							</section>
						</article>
					</div>
				<?php endwhile; ?>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</main>

<?php get_footer(); ?>