<?php
/*
Template Name: Product Page
*/
get_header(); ?>
<main class="products-wrap">
<?php while( have_posts() ): the_post(); ?>
	<div class="container">
		<nav class="product-type">
			<?php wp_nav_menu( array( 'theme_location' => 'product_nav', 'container' => '', 'menu-class' => 'product-nav' ) ); ?>
		</nav>
		<div class="clear"></div>
	</div>

	<div class="featured">
		<div class="container">

			<article class="hentry span5">
				<h1 class="big"><?php echo get_post_meta( get_the_ID(), 'product_headline', true); ?></h1>
				<section class="entry">
					<?php the_content(); ?>
				</section>

			</article>

			<div class="clear"></div>
		</div>
		<div class="background">
			<?php the_post_thumbnail('full'); ?>
		</div>
	</div>

	<div class="product-list container">
		<div class="span12">
			<div class="product-tools-wrap">
				<div class="span6">
					<div class="inner">
						Volume Calculator tool to be added.
					</div>
				</div>
				<div class="span6">
					<?php get_template_part('templates/tools', 'conversion'); ?>
				</div>
				<div class="clear"></div>
			</div>

			<div id="tab-container" class="tab-container">
				<ul class='etabs'>
					<li class='tab'><a href="#tabs1-html">Horizontal Type</a></li>
					<li class='tab'><a href="#tabs1-js">Vertical Type</a></li>
					<button class="show-tools-toggle">View Tools</button>
				</ul>
				<div id="tabs1-html" class="tab-content">
					<div class="span6">
						<div class="inner">
							<?php echo wp_get_attachment_image( get_post_meta( get_the_ID(), 'product_sketch_h', true ), 'full' ); ?>
						</div>
					</div>
					<div class="span6">
						<div class="inner2">
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
							<?php $h_products = get_post_meta( get_the_ID(), 'products_table_h', false); ?>
								<tr>
									<th clas="col1">Product ID</th>
									<th clas="col2">Capacity</th>
									<th clas="col3">Diameter</th>
									<th clas="col5">Height</th>
									<th clas="col4">Length</th>
								</tr>
								<?php foreach($h_products as $h_product): ?>
								<tr>
									<td><?php echo get_array_index($h_product, 'id'); ?></td>
									<td><?php echo get_array_index($h_product, 'capacity'); ?></td>
									<td><?php echo get_array_index($h_product, 'diameter'); ?></td>
									<td><?php echo get_array_index($h_product, 'height'); ?></td>
									<td><?php echo get_array_index($h_product, 'length'); ?></td>
								</tr>
								<?php endforeach; ?>
							</table>
						</div>
					</div>
				</div>
				<div id="tabs1-js" class="tab-content">
					<div class="span6">
						<div class="inner">
							<?php echo wp_get_attachment_image( get_post_meta( get_the_ID(), 'product_sketch_v', true ), 'full' ); ?>
						</div>
					</div>
					<div class="span6">
						<div class="inner2">
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
							<?php $v_products = get_post_meta( get_the_ID(), 'products_table_v', false); ?>
								<tr>
									<th clas="col1">Product ID</th>
									<th clas="col2">Capacity</th>
									<th clas="col3">Diameter</th>
									<th clas="col5">Height</th>
									<th clas="col4">Length</th>
								</tr>
								<?php foreach($v_products as $v_product): ?>
								<tr>
									<td><?php echo get_array_index($v_product, 'id'); ?></td>
									<td><?php echo get_array_index($v_product, 'capacity'); ?></td>
									<td><?php echo get_array_index($v_product, 'diameter'); ?></td>
									<td><?php echo get_array_index($v_product, 'height'); ?></td>
									<td><?php echo get_array_index($v_product, 'length'); ?></td>
								</tr>
								<?php endforeach; ?>
							</table>
						</div>
					</div>
					<div class="clear"></div>
				</div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
<?php endwhile; ?>
</main>

<?php get_footer(); ?>