<?php
/*
Template Name: About
*/
get_header(); ?>
<main class="about page">
<?php while( have_posts() ): the_post(); ?>
	<div class="background">
		
		<div class="container">
			<div class="span5">
				<article class="hentry">
					<h1 class="title"><?php the_title(); ?></h1>
					<section class="entry">
						<?php the_content(); ?>
					</section>
				</article>
			</div>
			<div class="span7">
				<div class="img-slider">
				<?php $slides = get_post_meta(get_the_ID(), 'bg_slide_image', false); ?>
					<div class="cycle-slideshow" data-cycle-timeout=10000 data-cycle-prev=".prev" data-cycle-next=".next">
					<?php
						foreach($slides as $slide):
					    	echo wp_get_attachment_image($slide, 'full');
						endforeach;
					?>
					</div>
					<div class="slider-nav">
						<span class="prev"></span>
						<span class="next"></span>
					</div>
				</div>
			</div>

			<div class="clear"></div>
		</div>
		
	</div>
<?php endwhile; ?>
</main>
<?php get_footer(); ?>