<?php

//Homepage Metabox
add_filter( 'cmb_meta_boxes', 'ftank_headline_metabox' );
function ftank_headline_metabox( array $meta_boxes ) {

	$fields = array(
		array( 
		    'id'   => 'ftank_headline', 
		    'name' => 'Headline', 
		    'type' => 'text',
		),
	);

	$meta_boxes[] = array(
        'title' => 'Template Editor',
        'pages' => 'page',
        'context'    => 'normal',
        'priority'   => 'high',
        'fields' => $fields // an array of fields - see individual field documentation.
    );

	return $meta_boxes; 
}

//Products Metabox
add_filter( 'cmb_meta_boxes', 'ftank_products_metabox' );
function ftank_products_metabox( array $meta_boxes ) {

	$capacity = array(
		array(
			'id'	=> 'liters',
			'name'	=> 'in liters',
		    'type'	=> 'text',
		    'cols'	=> 6,
		),
		array(
			'id'	=> 'gallons',
			'name'	=> 'in gallons',
		    'type'	=> 'text',
		    'cols'	=> 6,
		),
	);

	$size = array(
		array(
			'id'	=> 'diameter',
			'name'	=> 'Diameter (in centimeters)',
		    'type'	=> 'text',
		    'cols'	=> 6,
		),
		array(
			'id'	=> 'height',
			'name'	=> 'Height (in centimeters)',
		    'type'	=> 'text',
		    'cols'	=> 6,
		),
	);

	$fields = array(
		array( 
		    'id'   => 'product_capacity', 
		    'name' => 'Capacity', 
		    'type' => 'group',
		    'fields' => $capacity,
		),
		array( 
		    'id'   => 'product_size', 
		    'name' => 'Size', 
		    'type' => 'group',
		    'fields' => $size,
		),
		array( 
		    'id'   => 'product_slide_img', 
		    'name' => 'Product Slide Image', 
		    'type' => 'image',
		    'repeatable' => true,
		    'repeatable_max' => 5,
		),
	);

	$meta_boxes[] = array(
        'title' => 'Product Editor',
        'pages' => 'product',
        'context'    => 'normal',
        'priority'   => 'high',
        'fields' => $fields // an array of fields - see individual field documentation.
    );

	return $meta_boxes; 
}

//Background slider
add_filter( 'cmb_meta_boxes', 'ftank_background_metabox' );
function ftank_background_metabox( array $meta_boxes ) {

	$fields = array(
		array( 
		    'id'   => 'bg_slide_image', 
		    'name' => 'Background Image',
		    'type' => 'image',
		    'repeatable' => true,
		    'repeatable_max' => 5,
		),
	);

	$meta_boxes[] = array(
        'title' => 'Background Slider',
        'pages' => 'page',
        'show_on' => array( 'page-template' => 'page-home.php', 'page-template' => 'page-about.php' ),
        'context'    => 'normal',
        'priority'   => 'high',
        'fields' => $fields // an array of fields - see individual field documentation.
    );

	return $meta_boxes; 
}

//Services Metabox
add_filter( 'cmb_meta_boxes', 'ftank_service_metabox' );
function ftank_service_metabox( array $meta_boxes ) {

	$service = array(
		array(
			'id'	=> 'photo',
			'name'	=> 'in liters',
		    'type'	=> 'image',
		    'cols'	=> 3,
		),
		array(
			'id'	=> 'gallons',
			'name'	=> 'in gallons',
		    'type'	=> 'wysiwyg',
		    'options' => array(
		        'textarea_rows' => 5,
		    ),
		    'cols'	=> 9,
		),
	);


	$fields = array(
		array( 
		    'id'   => 'ftank_services', 
		    'name' => 'Services', 
		    'type' => 'group',
		    'fields' => $service,
		    'repeatable' => true,
		    'repeatable_max' => 3,
		),
	);

	$meta_boxes[] = array(
        'title' => 'Services',
        'pages' => 'page',
        'show_on' => array( 'page-template' => 'page-services.php' ),
        'context'    => 'normal',
        'priority'   => 'high',
        'fields' => $fields // an array of fields - see individual field documentation.
    );

	return $meta_boxes; 
}

//Product Template Metabox
add_filter( 'cmb_meta_boxes', 'ftank_product_template_metabox' );
function ftank_product_template_metabox( array $meta_boxes ) {

	$products = array(
		array(
			'id'	=> 'id',
			'name'	=> 'Name/ID',
		    'type'	=> 'text',
		    'cols'	=> 3,
		),
		array(
			'id'	=> 'capacity',
			'name'	=> 'Capacity',
		    'type'	=> 'text',
		    'cols'	=> 3,
		),
		array(
			'id'	=> 'diameter',
			'name'	=> 'Diameter',
		    'type'	=> 'text',
		    'cols'	=> 2,
		),
		array(
			'id'	=> 'height',
			'name'	=> 'Height',
		    'type'	=> 'text',
		    'cols'	=> 2,
		),
		array(
			'id'	=> 'length',
			'name'	=> 'Length',
		    'type'	=> 'text',
		    'cols'	=> 2,
		),
	);


	$fields = array(
		array( 
		    'id'   => 'product_headline', 
		    'name' => 'Headline', 
		    'type' => 'textarea',
		    'fields' => $headline,
		),
		array( 
		    'id'   => 'product_sketch_h', 
		    'name' => 'Product Sketch (Horizontal)', 
		    'type' => 'image',
		),
		array( 
		    'id'   => 'products_table_h', 
		    'name' => 'Horizontal Products', 
		    'type' => 'group',
		    'fields' => $products,
		    'repeatable' => true,
		),
		array( 
		    'id'   => 'product_sketch_v', 
		    'name' => 'Product Sketch (Vertical)', 
		    'type' => 'image',
		),
		array( 
		    'id'   => 'products_table_v', 
		    'name' => 'Vertical Products', 
		    'type' => 'group',
		    'fields' => $products,
		    'repeatable' => true,
		),
	);

	$meta_boxes[] = array(
        'title' => 'Product Template',
        'pages' => 'page',
        'show_on' => array( 'page-template' => 'page-products2.php' ),
        'context'    => 'normal',
        'priority'   => 'high',
        'fields' => $fields // an array of fields - see individual field documentation.
    );

	return $meta_boxes; 
}


//Events Metabox
add_filter( 'cmb_meta_boxes', 'ftank_event_metabox' );
function ftank_event_metabox( array $meta_boxes ) {

	$event = array(
				array(
			'id'	=> 'photo',
			'name'	=> 'Photo',
		    'type'	=> 'image',
		),
		array(
			'id'	=> 'title',
			'name'	=> 'Title',
		    'type'	=> 'text',
		),
		array(
			'id'	=> 'content',
			'name'	=> 'Content',
		    'type'	=> 'wysiwyg',
		    'options' => array(
		        'textarea_rows' => 7,
		    ),
		),
	);


	$fields = array(
		array( 
		    'id'   => 'ftank_events', 
		    'name' => 'Events', 
		    'type' => 'group',
		    'fields' => $event,
		    'repeatable' => true,
		    'repeatable_max' => 3,
		),
	);

	$meta_boxes[] = array(
        'title' => 'Services',
        'pages' => 'page',
        'show_on' => array( 'page-template' => 'page-events.php' ),
        'context'    => 'normal',
        'priority'   => 'high',
        'fields' => $fields // an array of fields - see individual field documentation.
    );

	return $meta_boxes; 
}