<?php

namespace TdySports\InputFilter;

use TdyCommons\InputFilter\BaseInputFilter;
use Zend\InputFilter\Factory as InputFilterFactory;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Validator;

/**
 * Class Sport
 *
 * @package TdySports\InputFilter
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Group extends BaseInputFilter
{

    /**
     * @param ServiceLocatorInterface $sm
     * @param bool                    $isEdit
     */
    public function __construct($sm, $isEdit = false)
    {
        $this->sm = $sm;

        $factory = new InputFilterFactory();

        $this->add($factory->createInput([
            'name'     => 'id',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'sport-id',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Sport ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid Sport ID.',
                            Validator\Digits::INVALID      => 'Invalid Sport ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'league-id',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('League ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid League ID.',
                            Validator\Digits::INVALID      => 'Invalid League ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'slug',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Slug is required.'),
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'short-name',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Group short name is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'name',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Group name is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'     => 'description',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

    }

}