/**
 * Configuration
 */
FanSportsApp.config([ '$httpProvider', '$stateProvider', '$urlRouterProvider', function ($httpProvider, $stateProvider, $urlRouterProvider) {
    $httpProvider.defaults.headers.common[ "X-Requested-With" ] = 'XMLHttpRequest';

    $stateProvider
        .state('home', {
            url        : '/',
            templateUrl: SportsFanPlayer.basePath + '/players/html/list'
        });

    $urlRouterProvider.otherwise("/");
} ]);


/**
 * Service
 */
FanSportsApp.factory('PlayersService', [ '$http', function ($http) {

    var Grid = function Grid() {
        this.scope = null;
        this.loading = false;
        this.items = [];
        this.queryString = {
            q: '',  // Query
            f: '',  // Filter
            s: '',  // Sort
            x: ''   // Exclude
        };
        this.pagination = {
            currentPage: 1,
            pageSize   : 20
        };
        this.results = {
            totalItems: null,
            totalPages: null
        };
    };

    Grid.prototype = {};

    Grid.prototype.call = function (hasAll) {
        hasAll = typeof hasAll !== 'undefined' ? hasAll : false;

        var query = '';
        var fn = this;

        fn.loading = true;
        fn.items = [];

        query += 'q=' + fn.queryString.q;
        query += fn.queryString.f != '' ? ('&' + fn.queryString.f) : '';
        query += fn.queryString.s != '' ? ('&' + fn.queryString.s) : '';
        query += fn.queryString.x != '' ? ('&' + fn.queryString.x) : '';
        query += fn.pagination.pageSize != null ? '&l=' + fn.pagination.pageSize : '';
        query += '&p=' + fn.pagination.currentPage;

        $http({
            method: 'GET',
            url   : Constants.API.url + '/perks/transactions?' + query
        }).then(function (data) {
            if (hasAll) {
                var oscar = {
                    value: '',
                    name: 'All Transactions'
                };
                fn.items.unshift(oscar);
            }

            fn.items = data.data.response.data.entries;
            fn.results = {
                totalItems: data.data.response.data.pagination.totalItems,
                totalPages: data.data.response.data.pagination.totalPages
            };
            fn.loading = false;

            if (fn.scope != null) {
                fn.scope.$broadcast('rebuild:me');
            }
        }).then(function () {
            fn.loading = false;
        });
    };

    Grid.prototype.refresh = function () {
        this.queryString = {
            q: '',
            f: '',
            s: '',
            x: ''
        };
        this.pagination = {
            currentPage: 1,
            pageSize   : 20
        };
        this.call();
    };

    Grid.prototype.selectPage = function () {
        this.call();
    };

    Grid.prototype.get = function (id) {
        return $http({
            method: 'GET',
            url: SportsFanPlayer.basePath + '/perks/transactions/' + id
        });
    };

    Grid.prototype.post = function (data) {
        return $http({
            method: 'POST',
            url: SportsFanPlayer.basePath + '/perks/transactions',
            data: data
        });
    };

    Grid.prototype.put = function (id, data) {
        return $http({
            method: 'PUT',
            url: SportsFanPlayer.basePath + '/perks/transactions/' + id,
            data: data
        });
    };


    return Grid;

} ]);
