<?php

namespace TdyGames\Model;

use TdyCommons\Filter\Word\LowercaseFirst;
use TdyCommons\Model\Model;
use TdyPlayers\Model\Player;
use TdyPlayers\Table\Players;
use Zend\Filter\FilterChain;
use Zend\Filter\Word\DashToCamelCase;
use Zend\Filter\Word\UnderscoreToCamelCase;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\ServiceManager\ServiceManager;

/**
 * Class Player
 *
 * @package TdyGames\Model
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Slot extends Model
{


    /**
     * The unique ID for Sport.
     *
     * @var int
     */
    public $id = 0;

    /**
     * @var int
     */
    public $playerId = 0;

    /**
     * @var int
     */
    public $totalPoints = 0;

    /**
     * @var int
     */
    public $place = 0;

    /**
     * @var null|ServiceManager|ServiceLocatorInterface
     */
    protected $sm;

    /**
     * @param null $data
     * @param null $sm
     */
    public function __construct($data = null, $sm = null)
    {
        if (!empty($data) && is_array($data)) {
            $this->exchangeArray($data);
        }

        $this->sm = $sm;
    }

    /**
     * @param null|ServiceManager|ServiceLocatorInterface $sm
     */
    public function setServiceLocator($sm)
    {
        $this->sm = $sm;
    }

    /**
     * @see Model::exchangeArray()
     *
     * @param array $data
     */
    public function exchangeArray($data)
    {
        parent::exchangeArray($data);

        foreach ($data as $key => $value) {
            $filter = new FilterChain();
            if (strpos($key, '-') !== false) {
                $filter->attach(new DashToCamelCase());
            } else {
                $filter->attach(new UnderscoreToCamelCase());
            }

            $filter->attach(new LowercaseFirst());
            $nKey = $filter->filter($key);

            if (!property_exists(__CLASS__, $nKey)) {
                continue;
            } else {
                $inArray = in_array($nKey, ['id', 'contestId', 'playerId', 'totalPoints', 'place']);
                if ($inArray) {
                    $this->$nKey = (int) $value;
                } else {
                    $this->$nKey = $value;
                }
            }
        }
    }

    /**
     * @param int $id
     *
     * @return null|Player
     */
    public function getPlayer($id)
    {
        if (is_null($this->sm)) {
            return null;
        }

        if ($id > 0) {
            /**
             * @var Players $table
             * @var Player  $player
             */
            $table  = $this->sm->get('TdyPlayers\Table\Players');
            $player = $table->get($id);
            $player->setServiceLocator($this->sm);

            return $player;
        } else {
            return new Player(null);
        }
    }

    /**
     * @return \StdClass
     */
    public function toStdClass()
    {
        $object = parent::toStdClass();

        if (!is_null($this->sm)) {
            unset($object->playerId);

            $player         = $this->getPlayer($this->playerId);
            $object->player = $player->toStdClass();
        }

        return $object;
    }

}
