<?php

namespace TdyCommons\InputFilter;

use Zend\InputFilter\Factory as InputFilterFactory;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\ServiceManager\ServiceManager;
use Zend\Validator;

/**
 * Option Input Filter
 *
 * @author James Lloyd Atwil <james@nadows.com>
 */
class Option extends BaseInputFilter
{

    /**
     * @param ServiceLocatorInterface|null $sm
     */
    public function __construct($sm = null)
    {
        $this->sm = $sm;

        $factory = new InputFilterFactory();

        $this->add($factory->createInput([
            'name'     => 'id',
            'required' => false,
        ]));

        $this->add($factory->createInput([
            'name'       => 'slug',
            'required'   => false,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Option slug or short name is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'name',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Option must have a name.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'value',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Option must have a value.')
            ],
        ]));

    }

}