<?php

return [
    'router'       => [
        'routes' => [
            'avatars' => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/avatars',
                    'defaults' => [
                        'module'     => 'TdyAvatars',
                        'controller' => 'TdyAvatars\Controller\Web\Avatars',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index' => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdyAvatars',
                                'controller' => 'TdyAvatars\Controller\Web\Avatars',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'rest'  => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdyAvatars',
                                'controller' => 'TdyAvatars\Controller\Rest\Avatars',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                        'child_routes'  => [
                        ]
                    ],
                    'html'  => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdyAvatars',
                                'controller' => 'TdyAvatars\Controller\Web\Avatars',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
        ],
    ],
    'controllers'  => [
        'invokables' => [
            'TdyAvatars\Controller\Web\Avatars'  => 'TdyAvatars\Controller\Web\AvatarsController',
            'TdyAvatars\Controller\Rest\Avatars' => 'TdyAvatars\Controller\Rest\AvatarsController'
        ],
    ],
    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies'          => [
            'ViewJsonStrategy',
        ],
    ],

];
