<?php

return [
    'router'       => [
        'routes' => [
            'sports'            => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/sports',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Sports',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Sports',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Sports',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Sports',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Rest\Sports',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Sports',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'leagues'           => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/leagues',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Leagues',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Leagues',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Leagues',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Leagues',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Rest\Leagues',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Leagues',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'groups'            => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/groups',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Groups',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Groups',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Groups',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Groups',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Rest\Groups',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Groups',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'seasons'             => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/seasons',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Seasons',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Seasons',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Seasons',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Seasons',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:sn][.:format]',
                            'constraints' => [
                                'wk'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Rest\Seasons',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Seasons',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'weeks'             => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/weeks',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Weeks',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Weeks',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Weeks',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Weeks',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:wk][.:format]',
                            'constraints' => [
                                'wk'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Rest\Weeks',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Weeks',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'teams'             => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/teams',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Teams',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Teams',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Teams',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Teams',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Rest\Teams',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Teams',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'schedules'         => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/schedules',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Schedules',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Schedules',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Schedules',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Schedules',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Rest\Schedules',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Schedules',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'schedule-statuses' => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/schedule-statuses',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Statuses',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Statuses',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Statuses',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Statuses',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Rest\Statuses',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdySports',
                                'controller' => 'TdySports\Controller\Web\Statuses',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
        ],
    ],
    'controllers'  => [
        'invokables' => [
            'TdySports\Controller\Web\Sports'     => 'TdySports\Controller\Web\SportsController',
            'TdySports\Controller\Rest\Sports'    => 'TdySports\Controller\Rest\SportsController',
            'TdySports\Controller\Web\Leagues'    => 'TdySports\Controller\Web\LeaguesController',
            'TdySports\Controller\Rest\Leagues'   => 'TdySports\Controller\Rest\LeaguesController',
            'TdySports\Controller\Web\Groups'     => 'TdySports\Controller\Web\GroupsController',
            'TdySports\Controller\Rest\Groups'    => 'TdySports\Controller\Rest\GroupsController',
            'TdySports\Controller\Web\Seasons'      => 'TdySports\Controller\Web\SeasonsController',
            'TdySports\Controller\Rest\Seasons'     => 'TdySports\Controller\Rest\SeasonsController',
            'TdySports\Controller\Web\Weeks'      => 'TdySports\Controller\Web\WeeksController',
            'TdySports\Controller\Rest\Weeks'     => 'TdySports\Controller\Rest\WeeksController',
            'TdySports\Controller\Web\Teams'      => 'TdySports\Controller\Web\TeamsController',
            'TdySports\Controller\Rest\Teams'     => 'TdySports\Controller\Rest\TeamsController',
            'TdySports\Controller\Web\Schedules'  => 'TdySports\Controller\Web\SchedulesController',
            'TdySports\Controller\Rest\Schedules' => 'TdySports\Controller\Rest\SchedulesController',
            'TdySports\Controller\Web\Statuses'   => 'TdySports\Controller\Web\StatusesController',
            'TdySports\Controller\Rest\Statuses'  => 'TdySports\Controller\Rest\StatusesController',
        ],
    ],
    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies'          => [
            'ViewJsonStrategy',
        ],
    ],

];
