<?php

namespace TdyGames\InputFilter;

use TdyCommons\InputFilter\BaseInputFilter;
use Zend\InputFilter\Factory as InputFilterFactory;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Validator;

/**
 * Class Game
 *
 * @package TdyGames\InputFilter
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Contest extends BaseInputFilter
{

    /**
     * @param ServiceLocatorInterface $sm
     * @param bool                    $isEdit
     */
    public function __construct($sm, $isEdit = false)
    {
        $this->sm = $sm;

        $factory = new InputFilterFactory();

        $this->add($factory->createInput([
            'name'     => 'id',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'slug',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Slug is required.'),
                [
                    'name'    => '\Zend\Validator\Db\NoRecordExists',
                    'options' => [
                        'adapter'                => $this->sm->get('db-01'),
                        'table'                  => $this->sm->get('Config')['mappings']['views']['gme_contests_active']['name'],
                        'field'                  => $this->sm->get('Config')['mappings']['views']['gme_contests_active']['columns']['slug'],
                        'exclude'                => [
                            'field' => $this->sm->get('Config')['mappings']['views']['gme_contests_active']['columns']['id'],
                            'value' => $this->data['id']
                        ],
                        'encoding'               => 'UTF-8',
                        'messages'               => [
                            Validator\Db\NoRecordExists::ERROR_RECORD_FOUND => 'Slug is already taken.'
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'name',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Contest name is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'     => 'description',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'sport-id',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Invalid Sport ID.',
                            Validator\Digits::INVALID    => 'Invalid Sport ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'league-id',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Invalid League ID.',
                            Validator\Digits::INVALID    => 'Invalid League ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'min-players',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Must be a number.',
                            Validator\Digits::INVALID    => 'Must be a number.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'max-players',
            'required'   => false,
            'filters'    => $this->filterStrings(),
            'validators' => [
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS => 'Must be a number.',
                            Validator\Digits::INVALID    => 'Must be a number.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'entrance-fee',
            'required'   => false,
            'filters'    => $this->filterStrings(),

        ]));

        $this->add($factory->createInput([
            'name'       => 'prize',
            'required'   => false,
            'filters'    => $this->filterStrings(),

        ]));

    }

}