<?php

namespace TdyCommons\View\Helper;

use Zend\Mvc\Router\RouteMatch;
use Zend\View\Helper\AbstractHelper;

/**
 * Class Module
 * @package TdyCommons\View\Helper
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Module extends AbstractHelper
{

    /**
     * @var RouteMatch
     */
    protected $routeMatch;

    /**
     * @param $routeMatch
     *
     * @return $this
     */
    public function setRouteMatch($routeMatch)
    {
        $this->routeMatch = $routeMatch;

        return $this;
    }

    /**
     * @param bool $toLowerCase
     *
     * @return string
     */
    public function __invoke($toLowerCase = true)
    {
        if ($this->routeMatch) {
            $module = $this->routeMatch->getParam('module', 'application');
            if ($toLowerCase) {
                $module = strtolower($module);
            }

            return $module;
        } else {
            return '';
        }
    }

}
