<?php

namespace TdyAdmins\InputFilter;

use TdyCommons\InputFilter\BaseInputFilter;
use Zend\InputFilter\Factory as InputFilterFactory;
use Zend\Validator;

/**
 * Class Login
 * @package TdyAdmins\InputFilter
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Login extends BaseInputFilter
{

    public function __construct()
    {
        $factory = new InputFilterFactory();

        $this->add($factory->createInput([
            'name' => 'username',
            'required' => true,
            'validators' => [
                [
                    'name' => '\Zend\Validator\NotEmpty',
                    'options' => [
                        'encoding' => 'UTF-8',
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Username and password required.'
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name' => 'password',
            'required' => true,
            'validators' => [
                [
                    'name' => '\Zend\Validator\NotEmpty',
                    'options' => [
                        'encoding' => 'UTF-8',
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Username and password required.'
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ],
            ],
        ]));
    }

}