<?php

namespace TdyAdmins\Controller\Rest;

use TdyAdmins\Model\Admin;
use TdyAdmins\InputFilter\Admin as AdminInputFilter;
use TdyCommons\Controller\BaseRestController;
use Zend\View\Model\JsonModel;

class AdminsController extends BaseRestController
{
    protected $identifierName = 'id';

    /**
     * @return JsonModel
     */
    public function getList()
    {
        $this->getLogger()->debug('AdminsController::getList() start.');

        $q = $this->params()->fromQuery('q', '');
        $p = (int) $this->params()->fromQuery('p', 1);
        $l = (int) $this->params()->fromQuery(
            'l', $this->getSettingsTable()->get('items-per-page')
        );
        $s = $this->params()->fromQuery('s', []);
        $f = $this->params()->fromQuery('f', []);
        $x = [];

        $resultSet = $this->getAdminsTable()->setIndent(self::LOGGER_INDENT)
            ->fetch($q, $x, $f, $s, true);
        $resultSet->setCurrentPageNumber((int) $p);
        $resultSet->setItemCountPerPage($l);

        if ($p > 0) {
            $i = (($p - 1) * $l);
        } else {
            $i = 0;
        }

        $admins = iterator_to_array($resultSet, false);

        /**
         * @var int   $k
         * @var Admin $admin
         */
        foreach ($admins as $k => $admin) {
            $admin->setServiceLocator($this->getServiceLocator());
            $admins[$k]->row = ++$i;
            $admins[$k]      = $admin->toStdClass();
        }

        $this->getLogger()->debug('AdminsController::getList() end.');

        return $this->statusOk([
            'entries'    => $admins,
            'pagination' => [
                'pageNumber' => $p,
                'pageSize'   => $l,
                'totalItems' => $resultSet->getTotalItemCount(),
                'totalPages' => $resultSet->count(),
            ],

        ]);
    }

    /**
     * @param int|string $usr
     *
     * @return JsonModel
     */
    public function get($usr)
    {
        $admin = $this->getAdminsTable()->get($usr);

        return $this->statusOk([
            'entry'      => $admin->toStdClass(),
            'pagination' => [
                'pageNumber' => 1,
                'pageSize'   => 1,
                'totalItems' => 1,
                'totalPages' => 1,
            ],
        ]);
    }

    /**
     * @param mixed $data
     *
     * @return JsonModel
     */
    public function create($data)
    {
        $this->getLogger()->debug('AdminsController::create() start.');

        $data['id'] = 0;

        $inputFilter = new AdminInputFilter($this->getServiceLocator());
        $inputFilter->setData($data);

        if ($inputFilter->isValid()) {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Input Filter is valid. Continue.');

            $data = $inputFilter->getValues();

            $admin            = new Admin($data);
            $admin->createdBy = $this->getCurrentAdmin()->id;

            $admin = $this->getAdminsTable()->setIndent(self::LOGGER_INDENT)->save($admin);

            $this->getLogger()->debug('AdminsController::create() end.');

            return $this->statusOk([
                'entry'      => $admin->toStdClass(),
                'pagination' => [
                    'pageNumber' => 1,
                    'pageSize'   => 1,
                    'totalItems' => 1,
                    'totalPages' => 1,
                ],
            ]);
        } else {
            $this->getLogger()->debug('AdminsController::create() end.');

            return $this->statusBadRequest([
                'system'    => [
                    'id'          => 4001,
                    'description' => 'Invalid Request'
                ],
                'companies' => [
                    'description' => 'Submission is invalid.',
                    'details'     => $inputFilter->getMessages()
                ]
            ]);
        }
    }

    /**
     * @param int|string $id
     * @param mixed      $data
     *
     * @return JsonModel
     */
    public function update($id, $data)
    {
        $this->getLogger()->debug('AdminsController::update() start.');

        $data['id'] = (int) $id;

        $inputFilter = new AdminInputFilter($this->getServiceLocator(), true);
        $inputFilter->setData($data);

        if ($inputFilter->isValid()) {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Input Filter is valid. Continue.');

            $admin            = new Admin($data);
            $admin->updatedBy = $this->getCurrentAdmin()->id;
            $admin            = $this->getAdminsTable()->setIndent(self::LOGGER_INDENT)->save($admin);

            $this->getLogger()->debug('AdminsController::update() end.');

            return $this->statusOk([
                'entry'      => $admin->toStdClass(),
                'pagination' => [
                    'pageNumber' => 1,
                    'pageSize'   => 1,
                    'totalItems' => 1,
                    'totalPages' => 1,
                ],
            ]);
        } else {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Input Filter is invalid. Will not update.');

            $this->getLogger()->debug('AdminsController::update() end.');

            return $this->statusBadRequest([
                'system'    => [
                    'id'          => 4001,
                    'description' => 'Invalid Request'
                ],
                'companies' => [
                    'description' => 'Submission is invalid.',
                    'details'     => $inputFilter->getMessages(),
                ]
            ]);
        }
    }

    /**
     * @param int|string $id
     *
     * @return JsonModel
     * @throws \Exception
     */
    public function delete($id)
    {
        $this->getLogger()->debug('AdminsController::delete() start.');

        $this->getLogger()->debug(self::LOGGER_INDENT . 'Getting info.');

        if ($id > 0) {
            $admin = $this->getAdminsTable()->get($id);
            if ($admin) {

                $this->getLogger()->debug(self::LOGGER_INDENT . 'Admin ID       : ' . $id);
                $this->getLogger()->debug(self::LOGGER_INDENT . 'Admin Username : ' . $admin->username);
                $this->getLogger()->debug(self::LOGGER_INDENT . 'Admin Full Name: ' . $admin->fullName());
                $this->getLogger()->debug(self::LOGGER_INDENT . 'Admin Email    : ' . $admin->email);

                $admin->deletedBy = $this->getCurrentAdmin()->id;
                $this->getAdminsTable()->setIndent(self::LOGGER_INDENT)->delete($admin);

                $this->getLogger()->debug(self::LOGGER_INDENT . 'Admin has been deleted.');
                $this->getLogger()->debug('AdminsController::delete() end.');

                return $this->statusOk([
                    'entry'      => null,
                    'pagination' => [
                        'pageNumber' => 1,
                        'pageSize'   => 1,
                        'totalItems' => 1,
                        'totalPages' => 1,
                    ],
                ]);
            } else {
                $this->getLogger()->debug(self::LOGGER_INDENT . 'Admin ID ' . $id . ' does not exists.');
                $this->getLogger()->debug('AdminsController::delete() end.');

                return $this->statusNotFound();
            }
        } else {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Admin ID is requred for deletion.');
            $this->getLogger()->debug('AdminsController::delete() end.');

            return $this->statusNotFound();
        }
    }

}
