var FanSportsApp = angular.module('FanSportsApp', [
    'ngSanitize',
    'ngAnimate',
    'ui.router',
    'ui.bootstrap.dropdown',
    'ui.bootstrap.pagination',
    'ui.bootstrap.tpls',
    'mgcrea.ngStrap.helpers.dateParser',
    'mgcrea.ngStrap.tooltip',
    'mgcrea.ngStrap.modal',
    'mgcrea.ngStrap.datepicker',
    'mgcrea.ngStrap.timepicker',
    'angular-growl',
    'ui.select',
    'ngFileUpload'
]);

FanSportsApp.config([
    '$httpProvider', '$modalProvider', '$datepickerProvider', '$timepickerProvider', 'growlProvider',
    function ($httpProvider, $modalProvider, $datepickerProvider, $timepickerProvider, growlProvider) {
        $httpProvider.defaults.headers.common[ "X-Requested-With" ] = 'XMLHttpRequest';

        angular.extend($modalProvider.defaults, {
            animation: '',
            html     : true
        });

        angular.extend($datepickerProvider.defaults, {
            dateFormat     : 'MMMM d, yyyy',
            modelDateFormat: 'MMMM d, yyyy',
            startWeek      : 0,
            iconLeft       : 'fa fa-chevron-left',
            iconRight      : 'fa fa-chevron-right',
            dateType       : 'string'
        });

        angular.extend($timepickerProvider.defaults, {
            iconUp  : 'fa fa-chevron-up',
            iconDown: 'fa fa-chevron-down',
            timeType: 'string'
        });

        growlProvider.globalTimeToLive(5000);
        growlProvider.globalDisableCountDown(true);
    }
]);

FanSportsApp.controller('NavbarController', [ '$scope',
    function ($scope) {

        $scope.isCollapsed = true;

    }
]);

FanSportsApp.directive('fsaTable', [ '$window', '$timeout', function ($window, $timeout) {
    return {
        restrict: 'A',
        link    : function (scope, element) {

            var w = angular.element($window);

            $timeout(function () {
                var table = angular.element(element);
                var parent = table.parent()[ 0 ].offsetHeight;

                element.height(parent - 3);
            }, 50);

            w.bind('resize', function () {
                var table = angular.element(element);
                var parent = table.parent()[ 0 ].offsetHeight;

                element.height(parent - 3);
            });
        }
    }
} ]);

FanSportsApp.directive("fsaInputMatch", function () {
    return {
        require: "ngModel",
        scope  : {
            fsaInputMatch: '='
        },
        link   : function (scope, element, attrs, ctrl) {
            scope.$watch(function () {
                var combined;

                if (scope.fsaInputMatch || ctrl.$viewValue) {
                    combined = scope.fsaInputMatch + '_' + ctrl.$viewValue;
                }
                return combined;
            }, function (value) {
                if (value) {
                    ctrl.$parsers.unshift(function (viewValue) {
                        var origin = scope.fsaInputMatch;
                        if (origin !== viewValue) {
                            ctrl.$setValidity("fsaInputMatch", false);
                            return undefined;
                        } else {
                            ctrl.$setValidity("fsaInputMatch", true);
                            return viewValue;
                        }
                    });
                }
            });
        }
    };
});

FanSportsApp.directive('fsaDatepicker', function () {
    return {
        restrict: 'A',
        link    : function (scope, el) {
            var component = el.siblings('[data-toggle="datepicker"]');
            if (component.length) {
                component.on('click', function () {
                    el.trigger('focus');
                });
            }
        }
    };
});

FanSportsApp.directive('fsaTimepicker', function () {
    return {
        restrict: 'A',
        link    : function (scope, el) {
            var component = el.siblings('[data-toggle="timepicker"]');
            if (component.length) {
                component.on('click', function () {
                    el.trigger('focus');
                });
            }
        }
    };
});

FanSportsApp.directive("fsaSlugify", function(){
    return {
        require: 'ngModel',
        link: function(scope, element, attrs, ngModelController) {
            ngModelController.$parsers.push(function(data) {
                if (typeof data ==  'string') {
                    data = data.replace(/\s+/g, '-');
                    return data.toLowerCase();
                }
            });

            ngModelController.$formatters.push(function(data) {
                if (typeof data ==  'string') {
                    data = data.replace(/\s+/g, '-');
                    return data.toLowerCase();
                }
            });
        }
    };
});

FanSportsApp.filter('fsaSlugify', function () {
    return function (text) {
        var str = text.replace(/\s+/g, '-');
        return str.toLowerCase();
    };
})