<?php

namespace TdySports\Controller\Rest;

use TdySports\Model\Week;
use TdySports\InputFilter\Week as WeekInputFilter;
use TdyCommons\Controller\BaseRestController;
use Zend\View\Model\JsonModel;

class WeeksController extends BaseRestController
{
    protected $identifierName = 'id';

    /**
     * @return JsonModel
     */
    public function getList()
    {
        $this->getLogger()->debug('WeeksController::getList() start.');

        $q = $this->params()->fromQuery('q', '');
        $p = (int) $this->params()->fromQuery('p', 1);
        $l = (int) $this->params()->fromQuery(
            'l', $this->getSettingsTable()->get('items-per-page')
        );
        $s = $this->params()->fromQuery('s', []);
        $f = $this->params()->fromQuery('f', []);
        $x = [];

        $resultSet = $this->getWeeksTable()->setIndent(self::LOGGER_INDENT)->fetch($q, $x, $f, $s, true);
        $resultSet->setCurrentPageNumber((int) $p);
        $resultSet->setItemCountPerPage($l);

        if ($p > 0) {
            $i = (($p - 1) * $l);
        } else {
            $i = 0;
        }

        $weeks = iterator_to_array($resultSet, false);

        /**
         * @var int  $k
         * @var Week $week
         */
        foreach ($weeks as $k => $week) {
            $week->setServiceLocator($this->getServiceLocator());
            $weeks[$k]->row = ++$i;
            $weeks[$k]      = $week->toStdClass();
        }

        $this->getLogger()->debug('WeeksController::getList() end.');

        return $this->statusOk([
            'entries'    => $weeks,
            'pagination' => [
                'pageNumber' => $p,
                'pageSize'   => $l,
                'totalItems' => $resultSet->getTotalItemCount(),
                'totalPages' => $resultSet->count(),
            ],

        ]);
    }

    /**
     * @param int|string $id
     *
     * @return JsonModel
     */
    public function get($id)
    {
        $week = $this->getWeeksTable()->get($id);
        $week->setServiceLocator($this->getServiceLocator());

        return $this->statusOk([
            'entry'      => $week->toStdClass(),
            'pagination' => [
                'pageNumber' => 1,
                'pageSize'   => 1,
                'totalItems' => 1,
                'totalPages' => 1,
            ],
        ]);
    }

    /**
     * @param mixed $data
     *
     * @return JsonModel
     */
    public function create($data)
    {
        $this->getLogger()->debug('WeeksController::create() start.');

        $data['id'] = 0;

        $inputFilter = new WeekInputFilter($this->getServiceLocator());
        $inputFilter->setData($data);

        if ($inputFilter->isValid()) {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Input Filter is valid. Continue.');

            $data = $inputFilter->getValues();

            $week            = new Week($data);
            $week->createdBy = $this->getCurrentPlayer()->id;

            $week = $this->getWeeksTable()->setIndent(self::LOGGER_INDENT)->save($week);

            $week->setServiceLocator($this->getServiceLocator());

            $this->getLogger()->info(self::LOGGER_INDENT . 'Week ' . $week->name . ' has been created.');
            $this->getLogger()->debug('WeeksController::create() end.');

            return $this->statusOk([
                'entry'      => $week->toStdClass(),
                'pagination' => [
                    'pageNumber' => 1,
                    'pageSize'   => 1,
                    'totalItems' => 1,
                    'totalPages' => 1,
                ],
            ]);
        } else {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Input Filter is invalid. Bugging out.');
            $this->getLogger()->debug('WeeksController::create() end.');

            return $this->statusBadRequest([
                'system'    => [
                    'id'          => 4001,
                    'description' => 'Invalid Request'
                ],
                'companies' => [
                    'description' => 'Submission is invalid.',
                    'details'     => $inputFilter->getMessages()
                ]
            ]);
        }
    }

    /**
     * @param int|string $id
     * @param mixed      $data
     *
     * @return JsonModel
     */
    public function update($id, $data)
    {
        $this->getLogger()->debug('WeeksController::update() start.');

        $data['id'] = (int) $id;

        $inputFilter = new WeekInputFilter($this->getServiceLocator(), true);
        $inputFilter->setData($data);

        if ($inputFilter->isValid()) {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Input Filter is valid. Continue.');

            $week            = new Week($data);
            $week->updatedBy = $this->getCurrentPlayer()->id;
            $week            = $this->getWeeksTable()->setIndent(self::LOGGER_INDENT)->save($week);

            $week->setServiceLocator($this->getServiceLocator());

            $this->getLogger()->info(self::LOGGER_INDENT . 'Week ' . $week->name . ' has been updated.');
            $this->getLogger()->debug('WeeksController::update() end.');

            return $this->statusOk([
                'entry'      => $week->toStdClass(),
                'pagination' => [
                    'pageNumber' => 1,
                    'pageSize'   => 1,
                    'totalItems' => 1,
                    'totalPages' => 1,
                ],
            ]);
        } else {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Input Filter is invalid. Will not update.');
            $this->getLogger()->debug('WeeksController::update() end.');

            return $this->statusBadRequest([
                'system'    => [
                    'id'          => 4001,
                    'description' => 'Invalid Request'
                ],
                'companies' => [
                    'description' => 'Submission is invalid.',
                    'details'     => $inputFilter->getMessages(),
                ]
            ]);
        }
    }

    /**
     * @param int|string $id
     *
     * @return JsonModel
     * @throws \Exception
     */
    public function delete($id)
    {
        $this->getLogger()->debug('WeeksController::delete() start.');

        $this->getLogger()->debug(self::LOGGER_INDENT . 'Getting info.');

        if ($id > 0) {
            $week = $this->getWeeksTable()->get($id);
            if ($week) {

                $this->getLogger()->debug(self::LOGGER_INDENT . 'Week ID  : ' . $id);
                $this->getLogger()->debug(self::LOGGER_INDENT . 'Week Name: ' . $week->name);

                $week->deletedBy = $this->getCurrentPlayer()->id;
                $this->getWeeksTable()->setIndent(self::LOGGER_INDENT)->delete($week);

                $this->getLogger()->info(self::LOGGER_INDENT . 'Week ' . $week->name . ' has been deleted.');
                $this->getLogger()->debug('WeeksController::delete() end.');

                return $this->statusOk([
                    'entry'      => null,
                    'pagination' => [
                        'pageNumber' => 1,
                        'pageSize'   => 1,
                        'totalItems' => 1,
                        'totalPages' => 1,
                    ],
                ]);
            } else {
                $this->getLogger()->debug(self::LOGGER_INDENT . 'Week ID ' . $id . ' does not exists.');
                $this->getLogger()->debug('WeeksController::delete() end.');

                return $this->statusNotFound();
            }
        } else {
            $this->getLogger()->debug(self::LOGGER_INDENT . 'Week ID is requred for deletion.');
            $this->getLogger()->debug('WeeksController::delete() end.');

            return $this->statusNotFound();
        }
    }

}
