

FanSportsApp.controller('LoginController', ['$scope', '$http', '$window', 'growl',
    function ($scope, $http, $window, growl) {

        $scope.isLoggingIn = false;

        $scope.login = function () {
            $scope.isLoggingIn = true;
            $http({
                method: 'POST',
                url: SportsFanPlayer.basePath + '/login',
                data: {
                    username: $scope.username,
                    password: $scope.password
                }
            }).then(function (results) {
                var confirm = results.data.response.data.response;
                if (confirm) {
                    growl.success('Successfully authenticated. Logging in.', {
                        referenceId: 'login',
                        ttl: 2500,
                        onclose: function() {
                            $window.location.href = SportsFanPlayer.basePath + '/lobby';
                        }
                    });
                } else {
                    $scope.isLoggingIn = false;
                    growl.error('Invaid username or password.', {
                        referenceId: 'login'
                    });
                }
            });
        };

    }
]);