<?php

namespace TdyPlayers\View\Helper;

use TdyPlayers\Model\Player;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Session;
use Zend\View\Helper\AbstractHelper;

class CurrentPlayer extends AbstractHelper
{

    /**
     * @var ServiceLocatorInterface
     */
    protected $sm;

    /**
     * @return Player
     */
    public function __invoke()
    {
        $session = new Session\Container(SESSION_CONTAINER);
        if (isset($session->user)) {
            /** @var Player $player */
            $player = $this->sm->get('TdyPlayers\Table\Players')->get($session->user->id);
            $player->setServiceLocator($this->sm);

            return $player;
        } else {
            return new Player();
        }
    }

    /**
     * @return ServiceLocatorInterface
     */
    public function getServiceLocator()
    {
        return $this->sm;
    }

    /**
     * @param ServiceLocatorInterface $sm
     */
    public function setServiceLocator(ServiceLocatorInterface $sm)
    {
        $this->sm = $sm;
    }

}
