<?php

namespace TdyPlayers;

use TdyPlayers\Model\Player;
use Zend\Authentication\Adapter as AuthAdapter;
use Zend\Authentication\Storage;
use Zend\Authentication\AuthenticationService;
use Zend\Db\Adapter\Adapter as DbAdapter;
use Zend\Db\ResultSet\HydratingResultSet;
use Zend\Db\TableGateway\TableGateway;
use Zend\Di\ServiceLocatorInterface;
use Zend\ModuleManager\Feature\AutoloaderProviderInterface;
use Zend\ModuleManager\Feature\ConfigProviderInterface;
use Zend\ModuleManager\Feature\ServiceProviderInterface;
use Zend\ModuleManager\Feature\ViewHelperProviderInterface;
use Zend\Session;
use Zend\View\HelperPluginManager;

class Module implements AutoloaderProviderInterface, ConfigProviderInterface, ServiceProviderInterface, ViewHelperProviderInterface
{

    public function getConfig()
    {
        $general = include __DIR__ . '/config/general.php';
        $db      = include __DIR__ . '/config/db.php';

        return array_merge($general, $db);
    }

    public function getAutoloaderConfig()
    {
        return [
            'Zend\Loader\StandardAutoloader' => [
                'namespaces' => [
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ],
            ],
        ];
    }

    public function getViewHelperConfig()
    {
        return [
            'factories' => [
                'currentPlayer' => function ($hpm) {
                    /** @var HelperPluginManager $hpm */
                    $locator = $hpm->getServiceLocator();
                    $player   = new View\Helper\CurrentPlayer();
                    $player->setServiceLocator($locator);

                    return $player;
                },
            ],
        ];
    }

    public function getServiceConfig()
    {
        return [
            'factories' => [
                'CurrentPlayer' => function ($sm) {
                    $session = new Session\Container(SESSION_CONTAINER);
                    if (isset($session->user)) {
                        /**
                         * @var ServiceLocatorInterface $sm
                         * @var Player                   $player
                         */
                        $player = $sm->get('TdyPlayers\Table\Players')->get($session->user->id);

                        return $player;
                    } else {
                        return new Player();
                    }
                },
                'TdyPlayers\Table\Players' => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['players']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['players']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Player());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Players($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'AuthStorage' => function () {
                    return new Storage\Session('auth');
                },
                'AuthService\Db' => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['players']['name'];

                    /** @var Storage\Session $storage */
                    $storage = $sm->get('AuthStorage');

                    $dbTableAuthAdapter = new Authentication\Adapter\DbTable\BcryptTreatment($dbAdapter, $tableName, 'username', 'password', 'is_active = 1');
                    $authService        = new AuthenticationService();
                    $authService->setAdapter($dbTableAuthAdapter);
                    $authService->setStorage($storage);

                    return $authService;
                },

            ],
        ];
    }

}