<?php

namespace Application\Controller;

use TdyCommons\Controller\BaseWebController;
use Zend\Http\PhpEnvironment\Response as PhpResponse;
use Zend\View\Model\ViewModel;

class IndexController extends BaseWebController
{

    public function indexAction()
    {
        $currentPlayer = $this->getCurrentPlayer();
        if ($currentPlayer->id > 0) {
            return $this->redirect()->toRoute('lobby');
        } else {
            return new ViewModel();
        }
    }

    public function lobbyAction()
    {
        return new ViewModel();
    }

    /**
     * @return ViewModel
     */
    public function scriptAction()
    {
        /** @var PhpResponse $phpResponse */
        $phpResponse = $this->getResponse();
        $phpResponse->getHeaders()->addHeaderLine('Content-type', 'text/javascript');

        $view = new ViewModel();
        $view->setTerminal(true);
        $view->setTemplate('application/index/scp-script.js');

        return $view;
    }

}
