/**
 * Service
 */
FanSportsApp.factory('ContestsService', [ '$http', function ($http) {
    var Grid = {
        isLoading  : false,
        items      : [],
        queryString: {
            q: '',  // Query
            f: '',  // Filter
            s: ''   // Sort
        },
        pagination : {
            currentPage: 1,
            pageSize   : 20
        },
        results    : {
            totalItems: null,
            totalPages: null
        },
        call       : function () {
            var query = '';

            Grid.isLoading = true;

            query += 'q=' + Grid.queryString.q;
            query += Grid.queryString.f != '' ? ('&' + Grid.queryString.f) : '';
            query += Grid.queryString.s != '' ? ('&' + Grid.queryString.s) : '';
            query += Grid.pagination.pageSize > 0 ? '&l=' + Grid.pagination.pageSize : '';
            query += '&p=' + Grid.pagination.currentPage;

            $http({
                method: 'GET',
                url   : SportsFanAdmin.basePath + '/contests/rest?' + query
            }).then(function (data) {
                Grid.items = data.data.response.data.entries;
                Grid.results = {
                    totalItems: data.data.response.data.pagination.totalItems,
                    totalPages: data.data.response.data.pagination.totalPages
                };
                Grid.isLoading = false;
            });
        },
        promiseCall: function () {
            var query = '';

            Grid.isLoading = true;

            query += 'q=' + Grid.queryString.q;
            query += Grid.queryString.f != '' ? ('&' + Grid.queryString.f) : '';
            query += Grid.queryString.s != '' ? ('&' + Grid.queryString.s) : '';
            query += Grid.pagination.pageSize > 0 ? '&l=' + Grid.pagination.pageSize : '';
            query += '&p=' + Grid.pagination.currentPage;

            return $http({
                method: 'GET',
                url   : SportsFanAdmin.basePath + '/contests/rest/' + Grid.contest + '/players/' + Grid.player + '/mixtures?' + query
            });
        },
        refresh    : function () {
            Grid.queryString = {
                q: '',
                f: '',
                s: ''
            };
            Grid.pagination = {
                currentPage: 1,
                pageSize   : 20
            };
            Grid.call();
        },
        selectPage : function () {
            Grid.call();
            return false;
        }
    };

    var Actions = {
        'get': function (id) {
            return $http({
                method: 'GET',
                url: '/contests/rest/' + id
            });
        },
        'post': function (data) {
            return $http({
                method: 'POST',
                url: '/contests/rest',
                data: data
            })
        },
    };

    return {
        grid: Grid,
        actions: Actions
    };

} ]);


FanSportsApp.factory('ContestsSlotsService', [ '$http', function ($http) {
    var Grid = {
        contest: 0,
        isLoading  : false,
        items      : [],
        queryString: {
            q: '',  // Query
            f: '',  // Filter
            s: ''   // Sort
        },
        pagination : {
            currentPage: 1,
            pageSize   : 20
        },
        results    : {
            totalItems: null,
            totalPages: null
        },
        call       : function () {
            var query = '';

            Grid.isLoading = true;

            query += 'q=' + Grid.queryString.q;
            query += Grid.queryString.f != '' ? ('&' + Grid.queryString.f) : '';
            query += Grid.queryString.s != '' ? ('&' + Grid.queryString.s) : '';
            query += Grid.pagination.pageSize > 0 ? '&l=' + Grid.pagination.pageSize : '';
            query += '&p=' + Grid.pagination.currentPage;

            $http({
                method: 'GET',
                url   : SportsFanAdmin.basePath + '/contests/rest/' +Grid.contest + '/slots?' + query
            }).then(function (data) {
                Grid.items = data.data.response.data.entries;
                Grid.results = {
                    totalItems: data.data.response.data.pagination.totalItems,
                    totalPages: data.data.response.data.pagination.totalPages
                };
                Grid.isLoading = false;
            });
        },
        refresh    : function () {
            Grid.queryString = {
                q: '',
                f: '',
                s: ''
            };
            Grid.pagination = {
                currentPage: 1,
                pageSize   : 20
            };
            Grid.call();
        },
        selectPage : function () {
            Grid.call();
            return false;
        }
    };

    var Actions = {
        'get': function (id) {
            return $http({
                method: 'GET',
                url: '/contests/rest/' + id
            });
        },
        'post': function (data) {
            return $http({
                method: 'POST',
                url: '/contests/rest',
                data: data
            })
        }
    };

    return {
        grid: Grid,
        actions: Actions
    };

} ]);



FanSportsApp.factory('ContestsMixturesService', [ '$http', function ($http) {
    var Grid = {
        contest: 0,
        player: 0,
        isLoading  : false,
        items      : [],
        queryString: {
            q: '',  // Query
            f: '',  // Filter
            s: ''   // Sort
        },
        pagination : {
            currentPage: 1,
            pageSize   : 20
        },
        results    : {
            totalItems: null,
            totalPages: null
        },
        call       : function () {
            var query = '';

            Grid.isLoading = true;

            query += 'q=' + Grid.queryString.q;
            query += Grid.queryString.f != '' ? ('&' + Grid.queryString.f) : '';
            query += Grid.queryString.s != '' ? ('&' + Grid.queryString.s) : '';
            query += Grid.pagination.pageSize > 0 ? '&l=' + Grid.pagination.pageSize : '';
            query += '&p=' + Grid.pagination.currentPage;

            $http({
                method: 'GET',
                url   : SportsFanAdmin.basePath + '/contests/rest/' + Grid.contest + '/players/' + Grid.player + '/mixtures?' + query
            }).then(function (data) {
                Grid.items = data.data.response.data.entries;
                Grid.results = {
                    totalItems: data.data.response.data.pagination.totalItems,
                    totalPages: data.data.response.data.pagination.totalPages
                };
                Grid.isLoading = false;
            });
        },
        promiseCall: function () {
            var query = '';

            Grid.isLoading = true;

            query += 'q=' + Grid.queryString.q;
            query += Grid.queryString.f != '' ? ('&' + Grid.queryString.f) : '';
            query += Grid.queryString.s != '' ? ('&' + Grid.queryString.s) : '';
            query += Grid.pagination.pageSize > 0 ? '&l=' + Grid.pagination.pageSize : '';
            query += '&p=' + Grid.pagination.currentPage;

            return $http({
                method: 'GET',
                url   : SportsFanAdmin.basePath + '/contests/rest/' + Grid.contest + '/players/' + Grid.player + '/mixtures?' + query
            });
        },
        refresh    : function () {
            Grid.queryString = {
                q: '',
                f: '',
                s: ''
            };
            Grid.pagination = {
                currentPage: 1,
                pageSize   : 20
            };
            Grid.call();
        },
        selectPage : function () {
            Grid.call();
            return false;
        }
    };

    var Actions = {
        'get': function (id) {
            return $http({
                method: 'GET',
                url: '/contests/rest/' + id
            });
        },
        'post': function (data) {
            return $http({
                method: 'POST',
                url: '/contests/rest',
                data: data
            })
        }
    };

    return {
        grid: Grid,
        actions: Actions
    };

} ]);