<?php

namespace TdyCommons\Model;

use TdyCommons\Filter\Word\LowercaseFirst;
use Zend\Filter\FilterChain;
use Zend\Filter\Word\UnderscoreToCamelCase;

/**
 * Class Setting
 * @package TdyCommons\Model
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Setting extends Model
{

    /**
     * Setting ID.
     *
     * @var int
     */
    public $id = 0;

    /**
     * The setting key.
     *
     * @var string
     */
    public $key = '';

    /**
     * The setting value.
     *
     * @var null|string
     */
    public $value = null;

    /**
     * Role constructor.
     *
     * @param array $data
     */
    public function __construct($data = null)
    {
        if (!empty($data) && is_array($data)) {
            $this->exchangeArray($data);
        }
    }

    /**
     * @see Model::exchangeArray();
     *
     * @param array $data
     */
    public function exchangeArray($data)
    {
        $this->id    = (int) $data['id'];
        $this->key   = $data['key'];
        $this->value = $data['value'];
        parent::exchangeArray($data);
    }

}
