jQuery.validator.setDefaults({
	highlight: function(element) {
		jQuery(element).closest('.form-group').addClass('has-error has-feedback');
	},
	unhighlight: function(element) {
		jQuery(element).closest('.form-group').removeClass('has-error ');
	},
	errorElement: 'span',
	errorClass: 'help-block',
	errorPlacement: function(error, element) {
		if (element.parent('.input-group').length) {
			error.insertAfter(element.parent());
		} else {
			error.insertAfter(element);
		}
	}
});

Profile = {
	reload: function(canvas, title, page) {
        console.log(page);
		jQuery.ajax({
			url: page,
			xhr: function() {
				var xhr = new window.XMLHttpRequest();
				xhr.addEventListener('progress', function(e) {
					if (e.lengthComputable) {
						jQuery(document).skylo('set', (100 * e.loaded / e.total));
					}
				});
				return xhr;
			},
			beforeSend: function() {
				jQuery(document).skylo('start');
			},
			complete: function(response, status, xhr) {
				jQuery(document).skylo('end');
			},
			success: function(data) {
				jQuery(canvas).html(data);
				Profile.validateChangePassword();
			}
		});
	},
	validateChangePassword: function() {
		if (jQuery('form[name="form-user-change-password"]').length < 1) {
			return;
		}
		jQuery('form[name="form-user-change-password"]').validate({
			rules: {
				passwordOld: {
					required: true
				},
				passwordNew1: {
					required: true
				},
				passwordNew2: {
					required: true,
					equalTo: "#passwordNew1"
				}
			},
			messages: {
				passwordNew2: {
					equalTo: 'Password must match.'
				}
			}
		});
	},
	changePassword: function() {
		modalId = '#modal-profile';
		jQuery('body').on('click', modalId + ' .btn-save', function(e) {
			e.preventDefault();
			e.stopPropagation();
			isValid = jQuery('form[name="form-user-change-password"]').valid();

			if (isValid) {
				jQuery('form[name="form-user-change-password"]').ajaxSubmit({
					beforeSend: function() {
						jQuery(modalId + ' .btn').addClass('disabled');
					},
					complete: function() {
						jQuery(modalId + ' .btn').removeClass('disabled');
					},
					success: function() {
						url = RMDGlobal.basePath + '/profile/change-password';
						Profile.reload('#profile-canvas', '', url);
					}
				});
			}
		});
	}
};

jQuery(document).ready(function() {

	// Show Profile Start
	jQuery('body').on('shown.bs.modal', '#modal-profile', function() {

	});

	jQuery('body').on('hidden.bs.modal', '#modal-profile', function() {
		jQuery(this).removeData('bs.modal');
	});
	// Show Profile End

	jQuery('body').on('click', '#modal-profile .nav-pills a', function(e) {
		e.preventDefault();
		jQuery('#modal-profile .nav-pills li').removeClass('active');
		jQuery(this).parent().addClass('active');
		Profile.reload('#profile-canvas', '', jQuery(this).attr('href'));

	});

	Profile.changePassword();

});