<?php

namespace TdyAdmins\View\Helper;

use TdyAdmins\Model\Admin;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Session;
use Zend\View\Helper\AbstractHelper;

class CurrentAdmin extends AbstractHelper
{

    /**
     * @var ServiceLocatorInterface
     */
    protected $sm;

    /**
     * @return bool
     */
    public function __invoke()
    {
        $session = new Session\Container(SESSION_CONTAINER);
        if (isset($session->user)) {
            /** @var Admin $admin */
            $admin = $this->sm->get('TdyAdmins\Table\Admins')->get($session->user->id);

            return $admin;
        } else {
            return new Admin();
        }
    }

    /**
     * @return ServiceLocatorInterface
     */
    public function getServiceLocator()
    {
        return $this->sm;
    }

    /**
     * @param ServiceLocatorInterface $sm
     */
    public function setServiceLocator(ServiceLocatorInterface $sm)
    {
        $this->sm = $sm;
    }

}
