<?php
/**
 * Global Configuration Override
 *
 * You can use this file for overriding configuration values from modules, etc.
 * You would place values in here that are agnostic to the environment and not
 * sensitive to security.
 *
 * @NOTE: In practice, this file will typically be INCLUDED in your source
 * control, so do not include passwords or other sensitive information in this
 * file.
 */

return [
    'php-settings'    => [
        'display_startup_errors'     => true,
        'display_errors'             => true,
        'log_errors'                 => 1,
        'error_log'                  => 'data/logs/error.log',
        'max_execution_time'         => 60,
        'date.timezone'              => 'Asia/Manila',
    ],
    'db'              => [
        'adapters' => [
            'db-01' => [
                'driver'         => 'Pdo',
                'dsn'            => 'mysql:dbname=hostphne_remix;host=127.0.0.1',
                'username'       => 'hostphne_remix',
                'password'       => 'gvM4yTG3lGpSHN6V2L',
                'driver_options' => [
                    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES 'UTF8'",
                ],
            ],
        ],
    ],
    'cache' => [
        'config' => [

        ],
        'dir' => 'data/cache/'
    ],
    'session'         => [
        'config'     => [
            'class'   => 'Zend\Session\Config\SessionConfig',
            'options' => [
                'name'        => 'fansports-admin',
                'cookie_path' => '/',
            ],
        ],
        'storage'    => 'Zend\Session\Storage\SessionArrayStorage',
        'validators' => [
            'Zend\Session\Validator\RemoteAddr',
            'Zend\Session\Validator\HttpUserAgent',
        ],
    ],
    'service_manager' => [
        'abstract_factories' => [
            'Zend\Db\Adapter\AdapterAbstractServiceFactory',
        ],
        'factories'          => [
            'Navigation' => 'Zend\Navigation\Service\DefaultNavigationFactory',
        ],
    ],
];
